package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1StatefulSetConditionBuilder extends V1beta1StatefulSetConditionFluentImpl<V1beta1StatefulSetConditionBuilder> implements VisitableBuilder<V1beta1StatefulSetCondition,V1beta1StatefulSetConditionBuilder>{

    V1beta1StatefulSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1StatefulSetConditionBuilder(){
            this(true);
    }
    public V1beta1StatefulSetConditionBuilder(Boolean validationEnabled){
            this(new V1beta1StatefulSetCondition(), validationEnabled);
    }
    public V1beta1StatefulSetConditionBuilder(V1beta1StatefulSetConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1StatefulSetConditionBuilder(V1beta1StatefulSetConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1StatefulSetCondition(), validationEnabled);
    }
    public V1beta1StatefulSetConditionBuilder(V1beta1StatefulSetConditionFluent<?> fluent,V1beta1StatefulSetCondition instance){
            this(fluent, instance, true);
    }
    public V1beta1StatefulSetConditionBuilder(V1beta1StatefulSetConditionFluent<?> fluent,V1beta1StatefulSetCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1StatefulSetConditionBuilder(V1beta1StatefulSetCondition instance){
            this(instance,true);
    }
    public V1beta1StatefulSetConditionBuilder(V1beta1StatefulSetCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1StatefulSetCondition build(){
            V1beta1StatefulSetCondition buildable = new V1beta1StatefulSetCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1StatefulSetConditionBuilder that = (V1beta1StatefulSetConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
