package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1NetworkPolicyPeerBuilder extends V1beta1NetworkPolicyPeerFluentImpl<V1beta1NetworkPolicyPeerBuilder> implements VisitableBuilder<V1beta1NetworkPolicyPeer,V1beta1NetworkPolicyPeerBuilder>{

    V1beta1NetworkPolicyPeerFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1NetworkPolicyPeerBuilder(){
            this(true);
    }
    public V1beta1NetworkPolicyPeerBuilder(Boolean validationEnabled){
            this(new V1beta1NetworkPolicyPeer(), validationEnabled);
    }
    public V1beta1NetworkPolicyPeerBuilder(V1beta1NetworkPolicyPeerFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1NetworkPolicyPeerBuilder(V1beta1NetworkPolicyPeerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1NetworkPolicyPeer(), validationEnabled);
    }
    public V1beta1NetworkPolicyPeerBuilder(V1beta1NetworkPolicyPeerFluent<?> fluent,V1beta1NetworkPolicyPeer instance){
            this(fluent, instance, true);
    }
    public V1beta1NetworkPolicyPeerBuilder(V1beta1NetworkPolicyPeerFluent<?> fluent,V1beta1NetworkPolicyPeer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIpBlock(instance.getIpBlock());

            fluent.withNamespaceSelector(instance.getNamespaceSelector());

            fluent.withPodSelector(instance.getPodSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1NetworkPolicyPeerBuilder(V1beta1NetworkPolicyPeer instance){
            this(instance,true);
    }
    public V1beta1NetworkPolicyPeerBuilder(V1beta1NetworkPolicyPeer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIpBlock(instance.getIpBlock());

            this.withNamespaceSelector(instance.getNamespaceSelector());

            this.withPodSelector(instance.getPodSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1NetworkPolicyPeer build(){
            V1beta1NetworkPolicyPeer buildable = new V1beta1NetworkPolicyPeer();
            buildable.setIpBlock(fluent.getIpBlock());
            buildable.setNamespaceSelector(fluent.getNamespaceSelector());
            buildable.setPodSelector(fluent.getPodSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1NetworkPolicyPeerBuilder that = (V1beta1NetworkPolicyPeerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
