package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PriorityLevelConfigurationListBuilder extends V1alpha1PriorityLevelConfigurationListFluentImpl<V1alpha1PriorityLevelConfigurationListBuilder> implements VisitableBuilder<V1alpha1PriorityLevelConfigurationList,V1alpha1PriorityLevelConfigurationListBuilder>{

    V1alpha1PriorityLevelConfigurationListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PriorityLevelConfigurationListBuilder(){
            this(true);
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(Boolean validationEnabled){
            this(new V1alpha1PriorityLevelConfigurationList(), validationEnabled);
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(V1alpha1PriorityLevelConfigurationListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(V1alpha1PriorityLevelConfigurationListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PriorityLevelConfigurationList(), validationEnabled);
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(V1alpha1PriorityLevelConfigurationListFluent<?> fluent,V1alpha1PriorityLevelConfigurationList instance){
            this(fluent, instance, true);
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(V1alpha1PriorityLevelConfigurationListFluent<?> fluent,V1alpha1PriorityLevelConfigurationList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(V1alpha1PriorityLevelConfigurationList instance){
            this(instance,true);
    }
    public V1alpha1PriorityLevelConfigurationListBuilder(V1alpha1PriorityLevelConfigurationList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PriorityLevelConfigurationList build(){
            V1alpha1PriorityLevelConfigurationList buildable = new V1alpha1PriorityLevelConfigurationList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PriorityLevelConfigurationListBuilder that = (V1alpha1PriorityLevelConfigurationListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
