package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1CephFSPersistentVolumeSourceFluent<A extends V1CephFSPersistentVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToMonitors(int index,String item);
    public A setToMonitors(int index,String item);
    public A addToMonitors(String... items);
    public A addAllToMonitors(Collection<String> items);
    public A removeFromMonitors(String... items);
    public A removeAllFromMonitors(Collection<String> items);
    public List<String> getMonitors();
    public String getMonitor(int index);
    public String getFirstMonitor();
    public String getLastMonitor();
    public String getMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withMonitors(List<String> monitors);
    public A withMonitors(String... monitors);
    public Boolean hasMonitors();
    public A addNewMonitor(String arg1);
    public A addNewMonitor(StringBuilder arg1);
    public A addNewMonitor(StringBuffer arg1);
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public A withNewPath(String arg1);
    public A withNewPath(StringBuilder arg1);
    public A withNewPath(StringBuffer arg1);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public A withNewReadOnly(String arg1);
    public A withNewReadOnly(boolean arg1);
    public String getSecretFile();
    public A withSecretFile(String secretFile);
    public Boolean hasSecretFile();
    public A withNewSecretFile(String arg1);
    public A withNewSecretFile(StringBuilder arg1);
    public A withNewSecretFile(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1SecretReference getSecretRef();
    public V1SecretReference buildSecretRef();
    public A withSecretRef(V1SecretReference secretRef);
    public Boolean hasSecretRef();
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1SecretReference item);
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef();
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1SecretReference item);
    public String getUser();
    public A withUser(String user);
    public Boolean hasUser();
    public A withNewUser(String arg1);
    public A withNewUser(StringBuilder arg1);
    public A withNewUser(StringBuffer arg1);

    public interface SecretRefNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SecretReferenceFluent<V1CephFSPersistentVolumeSourceFluent.SecretRefNested<N>>{

        
    public N and();    public N endSecretRef();
}


}
