package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1DeploymentSpecBuilder extends AppsV1beta1DeploymentSpecFluentImpl<AppsV1beta1DeploymentSpecBuilder> implements VisitableBuilder<AppsV1beta1DeploymentSpec,AppsV1beta1DeploymentSpecBuilder>{

    AppsV1beta1DeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1DeploymentSpecBuilder(){
            this(true);
    }
    public AppsV1beta1DeploymentSpecBuilder(Boolean validationEnabled){
            this(new AppsV1beta1DeploymentSpec(), validationEnabled);
    }
    public AppsV1beta1DeploymentSpecBuilder(AppsV1beta1DeploymentSpecFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1DeploymentSpecBuilder(AppsV1beta1DeploymentSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1DeploymentSpec(), validationEnabled);
    }
    public AppsV1beta1DeploymentSpecBuilder(AppsV1beta1DeploymentSpecFluent<?> fluent,AppsV1beta1DeploymentSpec instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1DeploymentSpecBuilder(AppsV1beta1DeploymentSpecFluent<?> fluent,AppsV1beta1DeploymentSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinReadySeconds(instance.getMinReadySeconds());

            fluent.withPaused(instance.getPaused());

            fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            fluent.withReplicas(instance.getReplicas());

            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            fluent.withRollbackTo(instance.getRollbackTo());

            fluent.withSelector(instance.getSelector());

            fluent.withStrategy(instance.getStrategy());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1DeploymentSpecBuilder(AppsV1beta1DeploymentSpec instance){
            this(instance,true);
    }
    public AppsV1beta1DeploymentSpecBuilder(AppsV1beta1DeploymentSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withPaused(instance.getPaused());

            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withRollbackTo(instance.getRollbackTo());

            this.withSelector(instance.getSelector());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1DeploymentSpec build(){
            AppsV1beta1DeploymentSpec buildable = new AppsV1beta1DeploymentSpec();
            buildable.setMinReadySeconds(fluent.getMinReadySeconds());
            buildable.setPaused(fluent.isPaused());
            buildable.setProgressDeadlineSeconds(fluent.getProgressDeadlineSeconds());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setRevisionHistoryLimit(fluent.getRevisionHistoryLimit());
            buildable.setRollbackTo(fluent.getRollbackTo());
            buildable.setSelector(fluent.getSelector());
            buildable.setStrategy(fluent.getStrategy());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentSpecBuilder that = (AppsV1beta1DeploymentSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
