/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceAttribute must have exactly one field set.")
public class V1beta2DeviceAttribute {
    public static final String SERIALIZED_NAME_BOOL = "bool";
    @SerializedName(value="bool")
    @Nullable
    private Boolean bool;
    public static final String SERIALIZED_NAME_INT = "int";
    @SerializedName(value="int")
    @Nullable
    private Long _int;
    public static final String SERIALIZED_NAME_STRING = "string";
    @SerializedName(value="string")
    @Nullable
    private String string;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nullable
    private String version;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceAttribute bool(@Nullable Boolean bool) {
        this.bool = bool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BoolValue is a true/false value.")
    public Boolean getBool() {
        return this.bool;
    }

    public void setBool(@Nullable Boolean bool) {
        this.bool = bool;
    }

    public V1beta2DeviceAttribute _int(@Nullable Long _int) {
        this._int = _int;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IntValue is a number.")
    public Long getInt() {
        return this._int;
    }

    public void setInt(@Nullable Long _int) {
        this._int = _int;
    }

    public V1beta2DeviceAttribute string(@Nullable String string) {
        this.string = string;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StringValue is a string. Must not be longer than 64 characters.")
    public String getString() {
        return this.string;
    }

    public void setString(@Nullable String string) {
        this.string = string;
    }

    public V1beta2DeviceAttribute version(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceAttribute v1beta2DeviceAttribute = (V1beta2DeviceAttribute)o;
        return Objects.equals(this.bool, v1beta2DeviceAttribute.bool) && Objects.equals(this._int, v1beta2DeviceAttribute._int) && Objects.equals(this.string, v1beta2DeviceAttribute.string) && Objects.equals(this.version, v1beta2DeviceAttribute.version);
    }

    public int hashCode() {
        return Objects.hash(this.bool, this._int, this.string, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceAttribute {\n");
        sb.append("    bool: ").append(this.toIndentedString(this.bool)).append("\n");
        sb.append("    _int: ").append(this.toIndentedString(this._int)).append("\n");
        sb.append("    string: ").append(this.toIndentedString(this.string)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceAttribute is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceAttribute` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_STRING) != null && !jsonObj.get(SERIALIZED_NAME_STRING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STRING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `string` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STRING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
    }

    public static V1beta2DeviceAttribute fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceAttribute)JSON.getGson().fromJson(jsonString, V1beta2DeviceAttribute.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BOOL);
        openapiFields.add(SERIALIZED_NAME_INT);
        openapiFields.add(SERIALIZED_NAME_STRING);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceAttribute.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceAttribute.class));
            return new TypeAdapter<V1beta2DeviceAttribute>(){

                public void write(JsonWriter out, V1beta2DeviceAttribute value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceAttribute read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceAttribute.validateJsonElement(jsonElement);
                    return (V1beta2DeviceAttribute)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

