/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.")
public class V1PodDNSConfig {
    public static final String SERIALIZED_NAME_NAMESERVERS = "nameservers";
    @SerializedName(value="nameservers")
    @Nullable
    private List<String> nameservers = new ArrayList<String>();
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    @Nullable
    private List<V1PodDNSConfigOption> options = new ArrayList<V1PodDNSConfigOption>();
    public static final String SERIALIZED_NAME_SEARCHES = "searches";
    @SerializedName(value="searches")
    @Nullable
    private List<String> searches = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodDNSConfig nameservers(@Nullable List<String> nameservers) {
        this.nameservers = nameservers;
        return this;
    }

    public V1PodDNSConfig addNameserversItem(String nameserversItem) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(nameserversItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.")
    public List<String> getNameservers() {
        return this.nameservers;
    }

    public void setNameservers(@Nullable List<String> nameservers) {
        this.nameservers = nameservers;
    }

    public V1PodDNSConfig options(@Nullable List<V1PodDNSConfigOption> options) {
        this.options = options;
        return this;
    }

    public V1PodDNSConfig addOptionsItem(V1PodDNSConfigOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<V1PodDNSConfigOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.")
    public List<V1PodDNSConfigOption> getOptions() {
        return this.options;
    }

    public void setOptions(@Nullable List<V1PodDNSConfigOption> options) {
        this.options = options;
    }

    public V1PodDNSConfig searches(@Nullable List<String> searches) {
        this.searches = searches;
        return this;
    }

    public V1PodDNSConfig addSearchesItem(String searchesItem) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(searchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.")
    public List<String> getSearches() {
        return this.searches;
    }

    public void setSearches(@Nullable List<String> searches) {
        this.searches = searches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodDNSConfig v1PodDNSConfig = (V1PodDNSConfig)o;
        return Objects.equals(this.nameservers, v1PodDNSConfig.nameservers) && Objects.equals(this.options, v1PodDNSConfig.options) && Objects.equals(this.searches, v1PodDNSConfig.searches);
    }

    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodDNSConfig {\n");
        sb.append("    nameservers: ").append(this.toIndentedString(this.nameservers)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    searches: ").append(this.toIndentedString(this.searches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayoptions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodDNSConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodDNSConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NAMESERVERS) != null && !jsonObj.get(SERIALIZED_NAME_NAMESERVERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESERVERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `nameservers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESERVERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonNull() && (jsonArrayoptions = jsonObj.getAsJsonArray(SERIALIZED_NAME_OPTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `options` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS).toString()));
            }
            for (int i = 0; i < jsonArrayoptions.size(); ++i) {
                V1PodDNSConfigOption.validateJsonElement(jsonArrayoptions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SEARCHES) != null && !jsonObj.get(SERIALIZED_NAME_SEARCHES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SEARCHES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `searches` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEARCHES).toString()));
        }
    }

    public static V1PodDNSConfig fromJson(String jsonString) throws IOException {
        return (V1PodDNSConfig)JSON.getGson().fromJson(jsonString, V1PodDNSConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAMESERVERS);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SEARCHES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodDNSConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodDNSConfig.class));
            return new TypeAdapter<V1PodDNSConfig>(){

                public void write(JsonWriter out, V1PodDNSConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodDNSConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodDNSConfig.validateJsonElement(jsonElement);
                    return (V1PodDNSConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

