package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.custom.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V2beta1ResourceMetricStatusFluentImpl<A extends V2beta1ResourceMetricStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ResourceMetricStatusFluent<A> {

    private Integer currentAverageUtilization;
    private Quantity currentAverageValue;
    private String name;

    public V2beta1ResourceMetricStatusFluentImpl() { 
    }


    public V2beta1ResourceMetricStatusFluentImpl(V2beta1ResourceMetricStatus instance) { 
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());

        this.withCurrentAverageValue(instance.getCurrentAverageValue());

        this.withName(instance.getName());

    }


    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    public A withCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization=currentAverageUtilization; return (A) this;
    }

    public Boolean hasCurrentAverageUtilization() {
        return this.currentAverageUtilization != null;
    }

    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue=currentAverageValue; return (A) this;
    }

    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    public A withNewCurrentAverageValue(final String value) {
        return (A)withCurrentAverageValue(new Quantity(value));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V2beta1ResourceMetricStatusFluentImpl that = (V2beta1ResourceMetricStatusFluentImpl) o;
        if (currentAverageUtilization != null ? !currentAverageUtilization.equals(that.currentAverageUtilization) :that.currentAverageUtilization != null) return false;
        if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(currentAverageUtilization,  currentAverageValue,  name,  super.hashCode());
    }

}
