package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1RunAsGroupStrategyOptionsBuilder extends V1beta1RunAsGroupStrategyOptionsFluentImpl<V1beta1RunAsGroupStrategyOptionsBuilder> implements VisitableBuilder<V1beta1RunAsGroupStrategyOptions,V1beta1RunAsGroupStrategyOptionsBuilder> {

    V1beta1RunAsGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1RunAsGroupStrategyOptionsBuilder() { 
        this(true);
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(Boolean validationEnabled) { 
        this(new V1beta1RunAsGroupStrategyOptions(), validationEnabled);
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(V1beta1RunAsGroupStrategyOptionsFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(V1beta1RunAsGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1RunAsGroupStrategyOptions(), validationEnabled);
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(V1beta1RunAsGroupStrategyOptionsFluent<?> fluent,V1beta1RunAsGroupStrategyOptions instance) { 
        this(fluent, instance, true);
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(V1beta1RunAsGroupStrategyOptionsFluent<?> fluent,V1beta1RunAsGroupStrategyOptions instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withRanges(instance.getRanges());

        fluent.withRule(instance.getRule());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(V1beta1RunAsGroupStrategyOptions instance) { 
        this(instance,true);
    }


    public V1beta1RunAsGroupStrategyOptionsBuilder(V1beta1RunAsGroupStrategyOptions instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withRanges(instance.getRanges());

        this.withRule(instance.getRule());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1RunAsGroupStrategyOptions build() {
        V1beta1RunAsGroupStrategyOptions buildable = new V1beta1RunAsGroupStrategyOptions();
        buildable.setRanges(fluent.getRanges());
        buildable.setRule(fluent.getRule());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1RunAsGroupStrategyOptionsBuilder that = (V1beta1RunAsGroupStrategyOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
