package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CustomResourceConversionFluentImpl<A extends V1beta1CustomResourceConversionFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CustomResourceConversionFluent<A> {

    private List<String> conversionReviewVersions;
    private String strategy;
    private ApiextensionsV1beta1WebhookClientConfigBuilder webhookClientConfig;

    public V1beta1CustomResourceConversionFluentImpl() { 
    }


    public V1beta1CustomResourceConversionFluentImpl(V1beta1CustomResourceConversion instance) { 
        this.withConversionReviewVersions(instance.getConversionReviewVersions());

        this.withStrategy(instance.getStrategy());

        this.withWebhookClientConfig(instance.getWebhookClientConfig());

    }


    public A addToConversionReviewVersions(int index,String item) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToConversionReviewVersions(int index,String item) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        this.conversionReviewVersions.set(index, item); return (A)this;
    }

    public A addToConversionReviewVersions(String... items) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromConversionReviewVersions(String... items) {
        for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: conversionReviewVersions) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConversionReviewVersion(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: conversionReviewVersions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (this.conversionReviewVersions != null) { _visitables.get("conversionReviewVersions").removeAll(this.conversionReviewVersions);}
        if (conversionReviewVersions != null) {this.conversionReviewVersions = new ArrayList<String>(); for (String item : conversionReviewVersions){this.addToConversionReviewVersions(item);}} else { this.conversionReviewVersions = null;} return (A) this;
    }

    public A withConversionReviewVersions(String... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {this.conversionReviewVersions.clear();}
        if (conversionReviewVersions != null) {for (String item :conversionReviewVersions){ this.addToConversionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasConversionReviewVersions() {
        return conversionReviewVersions != null && !conversionReviewVersions.isEmpty();
    }

    public A addNewConversionReviewVersion(String arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(StringBuilder arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(StringBuffer arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy=strategy; return (A) this;
    }

    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    public A withNewStrategy(String arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(StringBuilder arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(StringBuffer arg1) {
        return (A)withStrategy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildWebhookClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public ApiextensionsV1beta1WebhookClientConfig getWebhookClientConfig() {
        return this.webhookClientConfig!=null?this.webhookClientConfig.build():null;
    }

    public ApiextensionsV1beta1WebhookClientConfig buildWebhookClientConfig() {
        return this.webhookClientConfig!=null?this.webhookClientConfig.build():null;
    }

    public A withWebhookClientConfig(ApiextensionsV1beta1WebhookClientConfig webhookClientConfig) {
        _visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
        if (webhookClientConfig!=null){ this.webhookClientConfig= new ApiextensionsV1beta1WebhookClientConfigBuilder(webhookClientConfig); _visitables.get("webhookClientConfig").add(this.webhookClientConfig);} return (A) this;
    }

    public Boolean hasWebhookClientConfig() {
        return this.webhookClientConfig != null;
    }

    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfig() {
        return new WebhookClientConfigNestedImpl();
    }

    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfigLike(ApiextensionsV1beta1WebhookClientConfig item) {
        return new WebhookClientConfigNestedImpl(item);
    }

    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> editWebhookClientConfig() {
        return withNewWebhookClientConfigLike(getWebhookClientConfig());
    }

    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
        return withNewWebhookClientConfigLike(getWebhookClientConfig() != null ? getWebhookClientConfig(): new ApiextensionsV1beta1WebhookClientConfigBuilder().build());
    }

    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(ApiextensionsV1beta1WebhookClientConfig item) {
        return withNewWebhookClientConfigLike(getWebhookClientConfig() != null ? getWebhookClientConfig(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1CustomResourceConversionFluentImpl that = (V1beta1CustomResourceConversionFluentImpl) o;
        if (conversionReviewVersions != null ? !conversionReviewVersions.equals(that.conversionReviewVersions) :that.conversionReviewVersions != null) return false;
        if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
        if (webhookClientConfig != null ? !webhookClientConfig.equals(that.webhookClientConfig) :that.webhookClientConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conversionReviewVersions,  strategy,  webhookClientConfig,  super.hashCode());
    }

    public class WebhookClientConfigNestedImpl<N> extends ApiextensionsV1beta1WebhookClientConfigFluentImpl<V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<N>> implements V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final ApiextensionsV1beta1WebhookClientConfigBuilder builder;

        WebhookClientConfigNestedImpl(ApiextensionsV1beta1WebhookClientConfig item) {
            this.builder = new ApiextensionsV1beta1WebhookClientConfigBuilder(this, item);
        }

        WebhookClientConfigNestedImpl() {
            this.builder = new ApiextensionsV1beta1WebhookClientConfigBuilder(this);
        }

        public N and() {
             return (N) V1beta1CustomResourceConversionFluentImpl.this.withWebhookClientConfig(builder.build());
        }

        public N endWebhookClientConfig() {
             return and();
        }
    }


}
