package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.lang.Byte;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CertificateSigningRequestStatusFluentImpl<A extends V1beta1CertificateSigningRequestStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CertificateSigningRequestStatusFluent<A> {

    private List<Byte> certificate;
    private List<V1beta1CertificateSigningRequestConditionBuilder> conditions;

    public V1beta1CertificateSigningRequestStatusFluentImpl() { 
    }


    public V1beta1CertificateSigningRequestStatusFluentImpl(V1beta1CertificateSigningRequestStatus instance) { 
        this.withCertificate(instance.getCertificate());

        this.withConditions(instance.getConditions());

    }


    public A withCertificate(byte... certificate) {
        if (this.certificate != null) {this.certificate.clear();}
        if (certificate != null) {for (byte item :certificate){ this.addToCertificate(item);}} return (A) this;
    }

    public byte[] getCertificate() {
        //This needs to work with primitives, so we use arrays.
int size = certificate != null ? certificate.size() : 0;
byte[] result = new byte[size];
if (size == 0) {
   return result;
}
int index = 0;
for (byte item : certificate) {
    result[index++]=item;
}
return result;

    }

    public A addToCertificate(int index,Byte item) {
        if (this.certificate == null) {this.certificate = null;}
        this.certificate.add(index, item);
        return (A)this;
    }

    public A setToCertificate(int index,Byte item) {
        if (this.certificate == null) {this.certificate = null;}
        this.certificate.set(index, item); return (A)this;
    }

    public A addToCertificate(Byte... items) {
        if (this.certificate == null) {this.certificate = null;}
        for (Byte item : items) {this.certificate.add(item);} return (A)this;
    }

    public A addAllToCertificate(Collection<Byte> items) {
        if (this.certificate == null) {this.certificate = null;}
        for (Byte item : items) {this.certificate.add(item);} return (A)this;
    }

    public A removeFromCertificate(Byte... items) {
        for (Byte item : items) {if (this.certificate!= null){ this.certificate.remove(item);}} return (A)this;
    }

    public A removeAllFromCertificate(Collection<Byte> items) {
        for (Byte item : items) {if (this.certificate!= null){ this.certificate.remove(item);}} return (A)this;
    }

    public Boolean hasCertificate() {
        return certificate != null && !certificate.isEmpty();
    }

    public A addNewCertificate(String arg1) {
        return (A)addToCertificate(new Byte(arg1));
    }

    public A addNewCertificate(byte arg1) {
        return (A)addToCertificate(new Byte(arg1));
    }

    public A addToConditions(int index,V1beta1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();}
        V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1beta1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();}
        V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(V1beta1CertificateSigningRequestCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();}
        for (V1beta1CertificateSigningRequestCondition item : items) {V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1beta1CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();}
        for (V1beta1CertificateSigningRequestCondition item : items) {V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1beta1CertificateSigningRequestCondition... items) {
        for (V1beta1CertificateSigningRequestCondition item : items) {V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1beta1CertificateSigningRequestCondition> items) {
        for (V1beta1CertificateSigningRequestCondition item : items) {V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1beta1CertificateSigningRequestConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<V1beta1CertificateSigningRequestConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          V1beta1CertificateSigningRequestConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1CertificateSigningRequestCondition> getConditions() {
        return build(conditions);
    }

    public List<V1beta1CertificateSigningRequestCondition> buildConditions() {
        return build(conditions);
    }

    public V1beta1CertificateSigningRequestCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1beta1CertificateSigningRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1beta1CertificateSigningRequestCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public V1beta1CertificateSigningRequestCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1beta1CertificateSigningRequestConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1beta1CertificateSigningRequestConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<V1beta1CertificateSigningRequestCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>(); for (V1beta1CertificateSigningRequestCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1beta1CertificateSigningRequestCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (V1beta1CertificateSigningRequestCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta1CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta1CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta1CertificateSigningRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1CertificateSigningRequestStatusFluentImpl that = (V1beta1CertificateSigningRequestStatusFluentImpl) o;
        if (certificate != null ? !certificate.equals(that.certificate) :that.certificate != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(certificate,  conditions,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends V1beta1CertificateSigningRequestConditionFluentImpl<V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<N>> implements V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CertificateSigningRequestConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,V1beta1CertificateSigningRequestCondition item) {
            this.index = index;
            this.builder = new V1beta1CertificateSigningRequestConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1CertificateSigningRequestConditionBuilder(this);
        }

        public N and() {
             return (N) V1beta1CertificateSigningRequestStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
