package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CSIDriverFluentImpl<A extends V1beta1CSIDriverFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CSIDriverFluent<A> {

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1beta1CSIDriverSpecBuilder spec;

    public V1beta1CSIDriverFluentImpl() { 
    }


    public V1beta1CSIDriverFluentImpl(V1beta1CSIDriver instance) { 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public V1beta1CSIDriverFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public V1beta1CSIDriverFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public V1beta1CSIDriverFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public V1beta1CSIDriverFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta1CSIDriverFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1CSIDriverSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public V1beta1CSIDriverSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1beta1CSIDriverSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new V1beta1CSIDriverSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public V1beta1CSIDriverFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public V1beta1CSIDriverFluent.SpecNested<A> withNewSpecLike(V1beta1CSIDriverSpec item) {
        return new SpecNestedImpl(item);
    }

    public V1beta1CSIDriverFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public V1beta1CSIDriverFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new V1beta1CSIDriverSpecBuilder().build());
    }

    public V1beta1CSIDriverFluent.SpecNested<A> editOrNewSpecLike(V1beta1CSIDriverSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1CSIDriverFluentImpl that = (V1beta1CSIDriverFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta1CSIDriverFluent.MetadataNested<N>> implements V1beta1CSIDriverFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) V1beta1CSIDriverFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends V1beta1CSIDriverSpecFluentImpl<V1beta1CSIDriverFluent.SpecNested<N>> implements V1beta1CSIDriverFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1CSIDriverSpecBuilder builder;

        SpecNestedImpl(V1beta1CSIDriverSpec item) {
            this.builder = new V1beta1CSIDriverSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1beta1CSIDriverSpecBuilder(this);
        }

        public N and() {
             return (N) V1beta1CSIDriverFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


}
