package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1ResourcePolicyRuleFluentImpl<A extends V1alpha1ResourcePolicyRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1ResourcePolicyRuleFluent<A> {

    private List<String> apiGroups;
    private Boolean clusterScope;
    private List<String> namespaces;
    private List<String> resources;
    private List<String> verbs;

    public V1alpha1ResourcePolicyRuleFluentImpl() { 
    }


    public V1alpha1ResourcePolicyRuleFluentImpl(V1alpha1ResourcePolicyRule instance) { 
        this.withApiGroups(instance.getApiGroups());

        this.withClusterScope(instance.getClusterScope());

        this.withNamespaces(instance.getNamespaces());

        this.withResources(instance.getResources());

        this.withVerbs(instance.getVerbs());

    }


    public A addToApiGroups(int index,String item) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        this.apiGroups.add(index, item);
        return (A)this;
    }

    public A setToApiGroups(int index,String item) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        this.apiGroups.set(index, item); return (A)this;
    }

    public A addToApiGroups(String... items) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A removeFromApiGroups(String... items) {
        for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
    }

    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    public String getLastApiGroup() {
        return this.apiGroups.get(apiGroups.size() - 1);
    }

    public String getMatchingApiGroup(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: apiGroups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingApiGroup(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: apiGroups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withApiGroups(List<String> apiGroups) {
        if (this.apiGroups != null) { _visitables.get("apiGroups").removeAll(this.apiGroups);}
        if (apiGroups != null) {this.apiGroups = new ArrayList<String>(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
    }

    public A withApiGroups(String... apiGroups) {
        if (this.apiGroups != null) {this.apiGroups.clear();}
        if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
    }

    public Boolean hasApiGroups() {
        return apiGroups != null && !apiGroups.isEmpty();
    }

    public A addNewApiGroup(String arg1) {
        return (A)addToApiGroups(new String(arg1));
    }

    public A addNewApiGroup(StringBuilder arg1) {
        return (A)addToApiGroups(new String(arg1));
    }

    public A addNewApiGroup(StringBuffer arg1) {
        return (A)addToApiGroups(new String(arg1));
    }

    public Boolean isClusterScope() {
        return this.clusterScope;
    }

    public A withClusterScope(Boolean clusterScope) {
        this.clusterScope=clusterScope; return (A) this;
    }

    public Boolean hasClusterScope() {
        return this.clusterScope != null;
    }

    public A withNewClusterScope(String arg1) {
        return (A)withClusterScope(new Boolean(arg1));
    }

    public A withNewClusterScope(boolean arg1) {
        return (A)withClusterScope(new Boolean(arg1));
    }

    public A addToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
        if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces) {
        if (this.namespaces != null) {this.namespaces.clear();}
        if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces() {
        return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addToResources(int index,String item) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        this.resources.add(index, item);
        return (A)this;
    }

    public A setToResources(int index,String item) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        this.resources.set(index, item); return (A)this;
    }

    public A addToResources(String... items) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A removeFromResources(String... items) {
        for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
    }

    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(resources.size() - 1);
    }

    public String getMatchingResource(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: resources) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingResource(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: resources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResources(List<String> resources) {
        if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
        if (resources != null) {this.resources = new ArrayList<String>(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(String... resources) {
        if (this.resources != null) {this.resources.clear();}
        if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources() {
        return resources != null && !resources.isEmpty();
    }

    public A addNewResource(String arg1) {
        return (A)addToResources(new String(arg1));
    }

    public A addNewResource(StringBuilder arg1) {
        return (A)addToResources(new String(arg1));
    }

    public A addNewResource(StringBuffer arg1) {
        return (A)addToResources(new String(arg1));
    }

    public A addToVerbs(int index,String item) {
        if (this.verbs == null) {this.verbs = new ArrayList<String>();}
        this.verbs.add(index, item);
        return (A)this;
    }

    public A setToVerbs(int index,String item) {
        if (this.verbs == null) {this.verbs = new ArrayList<String>();}
        this.verbs.set(index, item); return (A)this;
    }

    public A addToVerbs(String... items) {
        if (this.verbs == null) {this.verbs = new ArrayList<String>();}
        for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {this.verbs = new ArrayList<String>();}
        for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A removeFromVerbs(String... items) {
        for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
    }

    public List<String> getVerbs() {
        return this.verbs;
    }

    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    public String getLastVerb() {
        return this.verbs.get(verbs.size() - 1);
    }

    public String getMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: verbs) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: verbs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVerbs(List<String> verbs) {
        if (this.verbs != null) { _visitables.get("verbs").removeAll(this.verbs);}
        if (verbs != null) {this.verbs = new ArrayList<String>(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
    }

    public A withVerbs(String... verbs) {
        if (this.verbs != null) {this.verbs.clear();}
        if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
    }

    public Boolean hasVerbs() {
        return verbs != null && !verbs.isEmpty();
    }

    public A addNewVerb(String arg1) {
        return (A)addToVerbs(new String(arg1));
    }

    public A addNewVerb(StringBuilder arg1) {
        return (A)addToVerbs(new String(arg1));
    }

    public A addNewVerb(StringBuffer arg1) {
        return (A)addToVerbs(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1ResourcePolicyRuleFluentImpl that = (V1alpha1ResourcePolicyRuleFluentImpl) o;
        if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
        if (clusterScope != null ? !clusterScope.equals(that.clusterScope) :that.clusterScope != null) return false;
        if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiGroups,  clusterScope,  namespaces,  resources,  verbs,  super.hashCode());
    }

}
