package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1PodPresetSpecFluentImpl<A extends V1alpha1PodPresetSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1PodPresetSpecFluent<A> {

    private List<V1EnvVarBuilder> env;
    private List<V1EnvFromSourceBuilder> envFrom;
    private V1LabelSelectorBuilder selector;
    private List<V1VolumeMountBuilder> volumeMounts;
    private List<V1VolumeBuilder> volumes;

    public V1alpha1PodPresetSpecFluentImpl() { 
    }


    public V1alpha1PodPresetSpecFluentImpl(V1alpha1PodPresetSpec instance) { 
        this.withEnv(instance.getEnv());

        this.withEnvFrom(instance.getEnvFrom());

        this.withSelector(instance.getSelector());

        this.withVolumeMounts(instance.getVolumeMounts());

        this.withVolumes(instance.getVolumes());

    }


    public A addToEnv(int index,V1EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
        V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,V1EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
        V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
        if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
        if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
         return (A)this;
    }

    public A addToEnv(V1EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
        for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(Collection<V1EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<V1EnvVarBuilder>();}
        for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(V1EnvVar... items) {
        for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<V1EnvVar> items) {
        for (V1EnvVar item : items) {V1EnvVarBuilder builder = new V1EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate) {
        if (env == null) return (A) this;
        final Iterator<V1EnvVarBuilder> each = env.iterator();
        final List visitables = _visitables.get("env");
        while (each.hasNext()) {
          V1EnvVarBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EnvVar> getEnv() {
        return build(env);
    }

    public List<V1EnvVar> buildEnv() {
        return build(env);
    }

    public V1EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public V1EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public V1EnvVar buildLastEnv() {
        return this.env.get(env.size() - 1).build();
    }

    public V1EnvVar buildMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate) {
        for (V1EnvVarBuilder item: env) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate) {
        for (V1EnvVarBuilder item: env) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEnv(List<V1EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<V1EnvVarBuilder>(); for (V1EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(V1EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (V1EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> addNewEnvLike(V1EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> setNewEnvLike(int index,V1EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> editEnv(int index) {
        if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> editFirstEnv() {
        if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
        return setNewEnvLike(0, buildEnv(0));
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> editLastEnv() {
        int index = env.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public V1alpha1PodPresetSpecFluent.EnvNested<A> editMatchingEnv(io.kubernetes.client.fluent.Predicate<V1EnvVarBuilder> predicate) {
        int index = -1;
        for (int i=0;i<env.size();i++) { 
        if (predicate.apply(env.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public A addToEnvFrom(int index,V1EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
        V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").add(index >= 0 ? index : _visitables.get("envFrom").size(), builder);this.envFrom.add(index >= 0 ? index : envFrom.size(), builder); return (A)this;
    }

    public A setToEnvFrom(int index,V1EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
        V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("envFrom").size()) { _visitables.get("envFrom").add(builder); } else { _visitables.get("envFrom").set(index, builder);}
        if (index < 0 || index >= envFrom.size()) { envFrom.add(builder); } else { envFrom.set(index, builder);}
         return (A)this;
    }

    public A addToEnvFrom(V1EnvFromSource... items) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
        for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
    }

    public A addAllToEnvFrom(Collection<V1EnvFromSource> items) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>();}
        for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
    }

    public A removeFromEnvFrom(V1EnvFromSource... items) {
        for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvFrom(Collection<V1EnvFromSource> items) {
        for (V1EnvFromSource item : items) {V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate) {
        if (envFrom == null) return (A) this;
        final Iterator<V1EnvFromSourceBuilder> each = envFrom.iterator();
        final List visitables = _visitables.get("envFrom");
        while (each.hasNext()) {
          V1EnvFromSourceBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnvFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EnvFromSource> getEnvFrom() {
        return build(envFrom);
    }

    public List<V1EnvFromSource> buildEnvFrom() {
        return build(envFrom);
    }

    public V1EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    public V1EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    public V1EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(envFrom.size() - 1).build();
    }

    public V1EnvFromSource buildMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate) {
        for (V1EnvFromSourceBuilder item: envFrom) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate) {
        for (V1EnvFromSourceBuilder item: envFrom) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEnvFrom(List<V1EnvFromSource> envFrom) {
        if (this.envFrom != null) { _visitables.get("envFrom").removeAll(this.envFrom);}
        if (envFrom != null) {this.envFrom = new ArrayList<V1EnvFromSourceBuilder>(); for (V1EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
    }

    public A withEnvFrom(V1EnvFromSource... envFrom) {
        if (this.envFrom != null) {this.envFrom.clear();}
        if (envFrom != null) {for (V1EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
    }

    public Boolean hasEnvFrom() {
        return envFrom != null && !envFrom.isEmpty();
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNestedImpl();
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> addNewEnvFromLike(V1EnvFromSource item) {
        return new EnvFromNestedImpl(-1, item);
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> setNewEnvFromLike(int index,V1EnvFromSource item) {
        return new EnvFromNestedImpl(index, item);
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> editEnvFrom(int index) {
        if (envFrom.size() <= index) throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> editFirstEnvFrom() {
        if (envFrom.size() == 0) throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        return setNewEnvFromLike(0, buildEnvFrom(0));
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> editLastEnvFrom() {
        int index = envFrom.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    public V1alpha1PodPresetSpecFluent.EnvFromNested<A> editMatchingEnvFrom(io.kubernetes.client.fluent.Predicate<V1EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<envFrom.size();i++) { 
        if (predicate.apply(envFrom.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching envFrom. No match found.");
        return setNewEnvFromLike(index, buildEnvFrom(index));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public V1alpha1PodPresetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public V1alpha1PodPresetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public V1alpha1PodPresetSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public V1alpha1PodPresetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1alpha1PodPresetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public A addToVolumeMounts(int index,V1VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
        V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
    }

    public A setToVolumeMounts(int index,V1VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
        V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
        if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
        if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
         return (A)this;
    }

    public A addToVolumeMounts(V1VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
        for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<V1VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>();}
        for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(V1VolumeMount... items) {
        for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<V1VolumeMount> items) {
        for (V1VolumeMount item : items) {V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeMounts(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate) {
        if (volumeMounts == null) return (A) this;
        final Iterator<V1VolumeMountBuilder> each = volumeMounts.iterator();
        final List visitables = _visitables.get("volumeMounts");
        while (each.hasNext()) {
          V1VolumeMountBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1VolumeMount> getVolumeMounts() {
        return build(volumeMounts);
    }

    public List<V1VolumeMount> buildVolumeMounts() {
        return build(volumeMounts);
    }

    public V1VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public V1VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public V1VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1).build();
    }

    public V1VolumeMount buildMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate) {
        for (V1VolumeMountBuilder item: volumeMounts) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate) {
        for (V1VolumeMountBuilder item: volumeMounts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<V1VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<V1VolumeMountBuilder>(); for (V1VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(V1VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (V1VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> addNewVolumeMountLike(V1VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,V1VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        return setNewVolumeMountLike(0, buildVolumeMount(0));
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = volumeMounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public V1alpha1PodPresetSpecFluent.VolumeMountsNested<A> editMatchingVolumeMount(io.kubernetes.client.fluent.Predicate<V1VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumeMounts.size();i++) { 
        if (predicate.apply(volumeMounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public A addToVolumes(int index,V1Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
        V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,V1Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
        V1VolumeBuilder builder = new V1VolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToVolumes(V1Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
        for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<V1Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
        for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(V1Volume... items) {
        for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<V1Volume> items) {
        for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<V1VolumeBuilder> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          V1VolumeBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Volume> getVolumes() {
        return build(volumes);
    }

    public List<V1Volume> buildVolumes() {
        return build(volumes);
    }

    public V1Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public V1Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public V1Volume buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public V1Volume buildMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate) {
        for (V1VolumeBuilder item: volumes) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate) {
        for (V1VolumeBuilder item: volumes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumes(List<V1Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<V1VolumeBuilder>(); for (V1Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(V1Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (V1Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> addNewVolumeLike(V1Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> setNewVolumeLike(int index,V1Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> editVolume(int index) {
        if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> editFirstVolume() {
        if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
        return setNewVolumeLike(0, buildVolume(0));
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> editLastVolume() {
        int index = volumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public V1alpha1PodPresetSpecFluent.VolumesNested<A> editMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumes.size();i++) { 
        if (predicate.apply(volumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1PodPresetSpecFluentImpl that = (V1alpha1PodPresetSpecFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (envFrom != null ? !envFrom.equals(that.envFrom) :that.envFrom != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  envFrom,  selector,  volumeMounts,  volumes,  super.hashCode());
    }

    public class EnvNestedImpl<N> extends V1EnvVarFluentImpl<V1alpha1PodPresetSpecFluent.EnvNested<N>> implements V1alpha1PodPresetSpecFluent.EnvNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index,V1EnvVar item) {
            this.index = index;
            this.builder = new V1EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new V1EnvVarBuilder(this);
        }

        public N and() {
             return (N) V1alpha1PodPresetSpecFluentImpl.this.setToEnv(index,builder.build());
        }

        public N endEnv() {
             return and();
        }
    }


    public class EnvFromNestedImpl<N> extends V1EnvFromSourceFluentImpl<V1alpha1PodPresetSpecFluent.EnvFromNested<N>> implements V1alpha1PodPresetSpecFluent.EnvFromNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1EnvFromSourceBuilder builder;
        private final int index;

        EnvFromNestedImpl(int index,V1EnvFromSource item) {
            this.index = index;
            this.builder = new V1EnvFromSourceBuilder(this, item);
        }

        EnvFromNestedImpl() {
            this.index = -1;
            this.builder = new V1EnvFromSourceBuilder(this);
        }

        public N and() {
             return (N) V1alpha1PodPresetSpecFluentImpl.this.setToEnvFrom(index,builder.build());
        }

        public N endEnvFrom() {
             return and();
        }
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1alpha1PodPresetSpecFluent.SelectorNested<N>> implements V1alpha1PodPresetSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) V1alpha1PodPresetSpecFluentImpl.this.withSelector(builder.build());
        }

        public N endSelector() {
             return and();
        }
    }


    public class VolumeMountsNestedImpl<N> extends V1VolumeMountFluentImpl<V1alpha1PodPresetSpecFluent.VolumeMountsNested<N>> implements V1alpha1PodPresetSpecFluent.VolumeMountsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1VolumeMountBuilder builder;
        private final int index;

        VolumeMountsNestedImpl(int index,V1VolumeMount item) {
            this.index = index;
            this.builder = new V1VolumeMountBuilder(this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new V1VolumeMountBuilder(this);
        }

        public N and() {
             return (N) V1alpha1PodPresetSpecFluentImpl.this.setToVolumeMounts(index,builder.build());
        }

        public N endVolumeMount() {
             return and();
        }
    }


    public class VolumesNestedImpl<N> extends V1VolumeFluentImpl<V1alpha1PodPresetSpecFluent.VolumesNested<N>> implements V1alpha1PodPresetSpecFluent.VolumesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index,V1Volume item) {
            this.index = index;
            this.builder = new V1VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new V1VolumeBuilder(this);
        }

        public N and() {
             return (N) V1alpha1PodPresetSpecFluentImpl.this.setToVolumes(index,builder.build());
        }

        public N endVolume() {
             return and();
        }
    }


}
