package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1FlowSchemaStatusFluentImpl<A extends V1alpha1FlowSchemaStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1FlowSchemaStatusFluent<A> {

    private List<V1alpha1FlowSchemaConditionBuilder> conditions;

    public V1alpha1FlowSchemaStatusFluentImpl() { 
    }


    public V1alpha1FlowSchemaStatusFluentImpl(V1alpha1FlowSchemaStatus instance) { 
        this.withConditions(instance.getConditions());

    }


    public A addToConditions(int index,V1alpha1FlowSchemaCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1FlowSchemaConditionBuilder>();}
        V1alpha1FlowSchemaConditionBuilder builder = new V1alpha1FlowSchemaConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1alpha1FlowSchemaCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1FlowSchemaConditionBuilder>();}
        V1alpha1FlowSchemaConditionBuilder builder = new V1alpha1FlowSchemaConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(V1alpha1FlowSchemaCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1FlowSchemaConditionBuilder>();}
        for (V1alpha1FlowSchemaCondition item : items) {V1alpha1FlowSchemaConditionBuilder builder = new V1alpha1FlowSchemaConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1alpha1FlowSchemaCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1FlowSchemaConditionBuilder>();}
        for (V1alpha1FlowSchemaCondition item : items) {V1alpha1FlowSchemaConditionBuilder builder = new V1alpha1FlowSchemaConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1alpha1FlowSchemaCondition... items) {
        for (V1alpha1FlowSchemaCondition item : items) {V1alpha1FlowSchemaConditionBuilder builder = new V1alpha1FlowSchemaConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1alpha1FlowSchemaCondition> items) {
        for (V1alpha1FlowSchemaCondition item : items) {V1alpha1FlowSchemaConditionBuilder builder = new V1alpha1FlowSchemaConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1alpha1FlowSchemaConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<V1alpha1FlowSchemaConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          V1alpha1FlowSchemaConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1FlowSchemaCondition> getConditions() {
        return build(conditions);
    }

    public List<V1alpha1FlowSchemaCondition> buildConditions() {
        return build(conditions);
    }

    public V1alpha1FlowSchemaCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1alpha1FlowSchemaCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1alpha1FlowSchemaCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public V1alpha1FlowSchemaCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1alpha1FlowSchemaConditionBuilder> predicate) {
        for (V1alpha1FlowSchemaConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1alpha1FlowSchemaConditionBuilder> predicate) {
        for (V1alpha1FlowSchemaConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<V1alpha1FlowSchemaCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<V1alpha1FlowSchemaConditionBuilder>(); for (V1alpha1FlowSchemaCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1alpha1FlowSchemaCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (V1alpha1FlowSchemaCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> addNewConditionLike(V1alpha1FlowSchemaCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1alpha1FlowSchemaCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1FlowSchemaStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1alpha1FlowSchemaConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1FlowSchemaStatusFluentImpl that = (V1alpha1FlowSchemaStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends V1alpha1FlowSchemaConditionFluentImpl<V1alpha1FlowSchemaStatusFluent.ConditionsNested<N>> implements V1alpha1FlowSchemaStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1FlowSchemaConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,V1alpha1FlowSchemaCondition item) {
            this.index = index;
            this.builder = new V1alpha1FlowSchemaConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1FlowSchemaConditionBuilder(this);
        }

        public N and() {
             return (N) V1alpha1FlowSchemaStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
