package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1FlowSchemaSpecFluentImpl<A extends V1alpha1FlowSchemaSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1FlowSchemaSpecFluent<A> {

    private V1alpha1FlowDistinguisherMethodBuilder distinguisherMethod;
    private Integer matchingPrecedence;
    private V1alpha1PriorityLevelConfigurationReferenceBuilder priorityLevelConfiguration;
    private List<V1alpha1PolicyRulesWithSubjectsBuilder> rules;

    public V1alpha1FlowSchemaSpecFluentImpl() { 
    }


    public V1alpha1FlowSchemaSpecFluentImpl(V1alpha1FlowSchemaSpec instance) { 
        this.withDistinguisherMethod(instance.getDistinguisherMethod());

        this.withMatchingPrecedence(instance.getMatchingPrecedence());

        this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration());

        this.withRules(instance.getRules());

    }


    
/**
 * This method has been deprecated, please use method buildDistinguisherMethod instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1FlowDistinguisherMethod getDistinguisherMethod() {
        return this.distinguisherMethod!=null?this.distinguisherMethod.build():null;
    }

    public V1alpha1FlowDistinguisherMethod buildDistinguisherMethod() {
        return this.distinguisherMethod!=null?this.distinguisherMethod.build():null;
    }

    public A withDistinguisherMethod(V1alpha1FlowDistinguisherMethod distinguisherMethod) {
        _visitables.get("distinguisherMethod").remove(this.distinguisherMethod);
        if (distinguisherMethod!=null){ this.distinguisherMethod= new V1alpha1FlowDistinguisherMethodBuilder(distinguisherMethod); _visitables.get("distinguisherMethod").add(this.distinguisherMethod);} return (A) this;
    }

    public Boolean hasDistinguisherMethod() {
        return this.distinguisherMethod != null;
    }

    public V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<A> withNewDistinguisherMethod() {
        return new DistinguisherMethodNestedImpl();
    }

    public V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<A> withNewDistinguisherMethodLike(V1alpha1FlowDistinguisherMethod item) {
        return new DistinguisherMethodNestedImpl(item);
    }

    public V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<A> editDistinguisherMethod() {
        return withNewDistinguisherMethodLike(getDistinguisherMethod());
    }

    public V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<A> editOrNewDistinguisherMethod() {
        return withNewDistinguisherMethodLike(getDistinguisherMethod() != null ? getDistinguisherMethod(): new V1alpha1FlowDistinguisherMethodBuilder().build());
    }

    public V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<A> editOrNewDistinguisherMethodLike(V1alpha1FlowDistinguisherMethod item) {
        return withNewDistinguisherMethodLike(getDistinguisherMethod() != null ? getDistinguisherMethod(): item);
    }

    public Integer getMatchingPrecedence() {
        return this.matchingPrecedence;
    }

    public A withMatchingPrecedence(Integer matchingPrecedence) {
        this.matchingPrecedence=matchingPrecedence; return (A) this;
    }

    public Boolean hasMatchingPrecedence() {
        return this.matchingPrecedence != null;
    }

    
/**
 * This method has been deprecated, please use method buildPriorityLevelConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PriorityLevelConfigurationReference getPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration!=null?this.priorityLevelConfiguration.build():null;
    }

    public V1alpha1PriorityLevelConfigurationReference buildPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration!=null?this.priorityLevelConfiguration.build():null;
    }

    public A withPriorityLevelConfiguration(V1alpha1PriorityLevelConfigurationReference priorityLevelConfiguration) {
        _visitables.get("priorityLevelConfiguration").remove(this.priorityLevelConfiguration);
        if (priorityLevelConfiguration!=null){ this.priorityLevelConfiguration= new V1alpha1PriorityLevelConfigurationReferenceBuilder(priorityLevelConfiguration); _visitables.get("priorityLevelConfiguration").add(this.priorityLevelConfiguration);} return (A) this;
    }

    public Boolean hasPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration != null;
    }

    public V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> withNewPriorityLevelConfiguration() {
        return new PriorityLevelConfigurationNestedImpl();
    }

    public V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> withNewPriorityLevelConfigurationLike(V1alpha1PriorityLevelConfigurationReference item) {
        return new PriorityLevelConfigurationNestedImpl(item);
    }

    public V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> editPriorityLevelConfiguration() {
        return withNewPriorityLevelConfigurationLike(getPriorityLevelConfiguration());
    }

    public V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfiguration() {
        return withNewPriorityLevelConfigurationLike(getPriorityLevelConfiguration() != null ? getPriorityLevelConfiguration(): new V1alpha1PriorityLevelConfigurationReferenceBuilder().build());
    }

    public V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfigurationLike(V1alpha1PriorityLevelConfigurationReference item) {
        return withNewPriorityLevelConfigurationLike(getPriorityLevelConfiguration() != null ? getPriorityLevelConfiguration(): item);
    }

    public A addToRules(int index,V1alpha1PolicyRulesWithSubjects item) {
        if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRulesWithSubjectsBuilder>();}
        V1alpha1PolicyRulesWithSubjectsBuilder builder = new V1alpha1PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,V1alpha1PolicyRulesWithSubjects item) {
        if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRulesWithSubjectsBuilder>();}
        V1alpha1PolicyRulesWithSubjectsBuilder builder = new V1alpha1PolicyRulesWithSubjectsBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(V1alpha1PolicyRulesWithSubjects... items) {
        if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRulesWithSubjectsBuilder>();}
        for (V1alpha1PolicyRulesWithSubjects item : items) {V1alpha1PolicyRulesWithSubjectsBuilder builder = new V1alpha1PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<V1alpha1PolicyRulesWithSubjects> items) {
        if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRulesWithSubjectsBuilder>();}
        for (V1alpha1PolicyRulesWithSubjects item : items) {V1alpha1PolicyRulesWithSubjectsBuilder builder = new V1alpha1PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(V1alpha1PolicyRulesWithSubjects... items) {
        for (V1alpha1PolicyRulesWithSubjects item : items) {V1alpha1PolicyRulesWithSubjectsBuilder builder = new V1alpha1PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<V1alpha1PolicyRulesWithSubjects> items) {
        for (V1alpha1PolicyRulesWithSubjects item : items) {V1alpha1PolicyRulesWithSubjectsBuilder builder = new V1alpha1PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRulesWithSubjectsBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<V1alpha1PolicyRulesWithSubjectsBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          V1alpha1PolicyRulesWithSubjectsBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PolicyRulesWithSubjects> getRules() {
        return build(rules);
    }

    public List<V1alpha1PolicyRulesWithSubjects> buildRules() {
        return build(rules);
    }

    public V1alpha1PolicyRulesWithSubjects buildRule(int index) {
        return this.rules.get(index).build();
    }

    public V1alpha1PolicyRulesWithSubjects buildFirstRule() {
        return this.rules.get(0).build();
    }

    public V1alpha1PolicyRulesWithSubjects buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public V1alpha1PolicyRulesWithSubjects buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRulesWithSubjectsBuilder> predicate) {
        for (V1alpha1PolicyRulesWithSubjectsBuilder item: rules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRulesWithSubjectsBuilder> predicate) {
        for (V1alpha1PolicyRulesWithSubjectsBuilder item: rules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRules(List<V1alpha1PolicyRulesWithSubjects> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<V1alpha1PolicyRulesWithSubjectsBuilder>(); for (V1alpha1PolicyRulesWithSubjects item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(V1alpha1PolicyRulesWithSubjects... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (V1alpha1PolicyRulesWithSubjects item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> addNewRuleLike(V1alpha1PolicyRulesWithSubjects item) {
        return new RulesNestedImpl(-1, item);
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> setNewRuleLike(int index,V1alpha1PolicyRulesWithSubjects item) {
        return new RulesNestedImpl(index, item);
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public V1alpha1FlowSchemaSpecFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRulesWithSubjectsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.apply(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1FlowSchemaSpecFluentImpl that = (V1alpha1FlowSchemaSpecFluentImpl) o;
        if (distinguisherMethod != null ? !distinguisherMethod.equals(that.distinguisherMethod) :that.distinguisherMethod != null) return false;
        if (matchingPrecedence != null ? !matchingPrecedence.equals(that.matchingPrecedence) :that.matchingPrecedence != null) return false;
        if (priorityLevelConfiguration != null ? !priorityLevelConfiguration.equals(that.priorityLevelConfiguration) :that.priorityLevelConfiguration != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(distinguisherMethod,  matchingPrecedence,  priorityLevelConfiguration,  rules,  super.hashCode());
    }

    public class DistinguisherMethodNestedImpl<N> extends V1alpha1FlowDistinguisherMethodFluentImpl<V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<N>> implements V1alpha1FlowSchemaSpecFluent.DistinguisherMethodNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1FlowDistinguisherMethodBuilder builder;

        DistinguisherMethodNestedImpl(V1alpha1FlowDistinguisherMethod item) {
            this.builder = new V1alpha1FlowDistinguisherMethodBuilder(this, item);
        }

        DistinguisherMethodNestedImpl() {
            this.builder = new V1alpha1FlowDistinguisherMethodBuilder(this);
        }

        public N and() {
             return (N) V1alpha1FlowSchemaSpecFluentImpl.this.withDistinguisherMethod(builder.build());
        }

        public N endDistinguisherMethod() {
             return and();
        }
    }


    public class PriorityLevelConfigurationNestedImpl<N> extends V1alpha1PriorityLevelConfigurationReferenceFluentImpl<V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<N>> implements V1alpha1FlowSchemaSpecFluent.PriorityLevelConfigurationNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1PriorityLevelConfigurationReferenceBuilder builder;

        PriorityLevelConfigurationNestedImpl(V1alpha1PriorityLevelConfigurationReference item) {
            this.builder = new V1alpha1PriorityLevelConfigurationReferenceBuilder(this, item);
        }

        PriorityLevelConfigurationNestedImpl() {
            this.builder = new V1alpha1PriorityLevelConfigurationReferenceBuilder(this);
        }

        public N and() {
             return (N) V1alpha1FlowSchemaSpecFluentImpl.this.withPriorityLevelConfiguration(builder.build());
        }

        public N endPriorityLevelConfiguration() {
             return and();
        }
    }


    public class RulesNestedImpl<N> extends V1alpha1PolicyRulesWithSubjectsFluentImpl<V1alpha1FlowSchemaSpecFluent.RulesNested<N>> implements V1alpha1FlowSchemaSpecFluent.RulesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1PolicyRulesWithSubjectsBuilder builder;
        private final int index;

        RulesNestedImpl(int index,V1alpha1PolicyRulesWithSubjects item) {
            this.index = index;
            this.builder = new V1alpha1PolicyRulesWithSubjectsBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1PolicyRulesWithSubjectsBuilder(this);
        }

        public N and() {
             return (N) V1alpha1FlowSchemaSpecFluentImpl.this.setToRules(index,builder.build());
        }

        public N endRule() {
             return and();
        }
    }


}
