package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1ValidatingWebhookConfigurationFluentImpl<A extends V1ValidatingWebhookConfigurationFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ValidatingWebhookConfigurationFluent<A> {

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1ValidatingWebhookBuilder> webhooks;

    public V1ValidatingWebhookConfigurationFluentImpl() { 
    }


    public V1ValidatingWebhookConfigurationFluentImpl(V1ValidatingWebhookConfiguration instance) { 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withWebhooks(instance.getWebhooks());

    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToWebhooks(int index,V1ValidatingWebhook item) {
        if (this.webhooks == null) {this.webhooks = new ArrayList<V1ValidatingWebhookBuilder>();}
        V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(index >= 0 ? index : _visitables.get("webhooks").size(), builder);this.webhooks.add(index >= 0 ? index : webhooks.size(), builder); return (A)this;
    }

    public A setToWebhooks(int index,V1ValidatingWebhook item) {
        if (this.webhooks == null) {this.webhooks = new ArrayList<V1ValidatingWebhookBuilder>();}
        V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
        if (index < 0 || index >= _visitables.get("webhooks").size()) { _visitables.get("webhooks").add(builder); } else { _visitables.get("webhooks").set(index, builder);}
        if (index < 0 || index >= webhooks.size()) { webhooks.add(builder); } else { webhooks.set(index, builder);}
         return (A)this;
    }

    public A addToWebhooks(V1ValidatingWebhook... items) {
        if (this.webhooks == null) {this.webhooks = new ArrayList<V1ValidatingWebhookBuilder>();}
        for (V1ValidatingWebhook item : items) {V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
    }

    public A addAllToWebhooks(Collection<V1ValidatingWebhook> items) {
        if (this.webhooks == null) {this.webhooks = new ArrayList<V1ValidatingWebhookBuilder>();}
        for (V1ValidatingWebhook item : items) {V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
    }

    public A removeFromWebhooks(V1ValidatingWebhook... items) {
        for (V1ValidatingWebhook item : items) {V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
    }

    public A removeAllFromWebhooks(Collection<V1ValidatingWebhook> items) {
        for (V1ValidatingWebhook item : items) {V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromWebhooks(io.kubernetes.client.fluent.Predicate<V1ValidatingWebhookBuilder> predicate) {
        if (webhooks == null) return (A) this;
        final Iterator<V1ValidatingWebhookBuilder> each = webhooks.iterator();
        final List visitables = _visitables.get("webhooks");
        while (each.hasNext()) {
          V1ValidatingWebhookBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildWebhooks instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ValidatingWebhook> getWebhooks() {
        return build(webhooks);
    }

    public List<V1ValidatingWebhook> buildWebhooks() {
        return build(webhooks);
    }

    public V1ValidatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    public V1ValidatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    public V1ValidatingWebhook buildLastWebhook() {
        return this.webhooks.get(webhooks.size() - 1).build();
    }

    public V1ValidatingWebhook buildMatchingWebhook(io.kubernetes.client.fluent.Predicate<V1ValidatingWebhookBuilder> predicate) {
        for (V1ValidatingWebhookBuilder item: webhooks) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingWebhook(io.kubernetes.client.fluent.Predicate<V1ValidatingWebhookBuilder> predicate) {
        for (V1ValidatingWebhookBuilder item: webhooks) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withWebhooks(List<V1ValidatingWebhook> webhooks) {
        if (this.webhooks != null) { _visitables.get("webhooks").removeAll(this.webhooks);}
        if (webhooks != null) {this.webhooks = new ArrayList<V1ValidatingWebhookBuilder>(); for (V1ValidatingWebhook item : webhooks){this.addToWebhooks(item);}} else { this.webhooks = null;} return (A) this;
    }

    public A withWebhooks(V1ValidatingWebhook... webhooks) {
        if (this.webhooks != null) {this.webhooks.clear();}
        if (webhooks != null) {for (V1ValidatingWebhook item :webhooks){ this.addToWebhooks(item);}} return (A) this;
    }

    public Boolean hasWebhooks() {
        return webhooks != null && !webhooks.isEmpty();
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new WebhooksNestedImpl();
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(V1ValidatingWebhook item) {
        return new WebhooksNestedImpl(-1, item);
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index,V1ValidatingWebhook item) {
        return new WebhooksNestedImpl(index, item);
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index) {
        if (webhooks.size() <= index) throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        return setNewWebhookLike(index, buildWebhook(index));
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (webhooks.size() == 0) throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        return setNewWebhookLike(0, buildWebhook(0));
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = webhooks.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        return setNewWebhookLike(index, buildWebhook(index));
    }

    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(io.kubernetes.client.fluent.Predicate<V1ValidatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i=0;i<webhooks.size();i++) { 
        if (predicate.apply(webhooks.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching webhooks. No match found.");
        return setNewWebhookLike(index, buildWebhook(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1ValidatingWebhookConfigurationFluentImpl that = (V1ValidatingWebhookConfigurationFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (webhooks != null ? !webhooks.equals(that.webhooks) :that.webhooks != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  webhooks,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1ValidatingWebhookConfigurationFluent.MetadataNested<N>> implements V1ValidatingWebhookConfigurationFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) V1ValidatingWebhookConfigurationFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class WebhooksNestedImpl<N> extends V1ValidatingWebhookFluentImpl<V1ValidatingWebhookConfigurationFluent.WebhooksNested<N>> implements V1ValidatingWebhookConfigurationFluent.WebhooksNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ValidatingWebhookBuilder builder;
        private final int index;

        WebhooksNestedImpl(int index,V1ValidatingWebhook item) {
            this.index = index;
            this.builder = new V1ValidatingWebhookBuilder(this, item);
        }

        WebhooksNestedImpl() {
            this.index = -1;
            this.builder = new V1ValidatingWebhookBuilder(this);
        }

        public N and() {
             return (N) V1ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(index,builder.build());
        }

        public N endWebhook() {
             return and();
        }
    }


}
