package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1TokenRequestStatusFluentImpl<A extends V1TokenRequestStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TokenRequestStatusFluent<A> {

    private DateTime expirationTimestamp;
    private String token;

    public V1TokenRequestStatusFluentImpl() { 
    }


    public V1TokenRequestStatusFluentImpl(V1TokenRequestStatus instance) { 
        this.withExpirationTimestamp(instance.getExpirationTimestamp());

        this.withToken(instance.getToken());

    }


    public DateTime getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public A withExpirationTimestamp(DateTime expirationTimestamp) {
        this.expirationTimestamp=expirationTimestamp; return (A) this;
    }

    public Boolean hasExpirationTimestamp() {
        return this.expirationTimestamp != null;
    }

    public A withNewExpirationTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withExpirationTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewExpirationTimestamp(Object arg0) {
        return (A)withExpirationTimestamp(new DateTime(arg0));
    }

    public A withNewExpirationTimestamp(long arg0) {
        return (A)withExpirationTimestamp(new DateTime(arg0));
    }

    public String getToken() {
        return this.token;
    }

    public A withToken(String token) {
        this.token=token; return (A) this;
    }

    public Boolean hasToken() {
        return this.token != null;
    }

    public A withNewToken(String arg1) {
        return (A)withToken(new String(arg1));
    }

    public A withNewToken(StringBuilder arg1) {
        return (A)withToken(new String(arg1));
    }

    public A withNewToken(StringBuffer arg1) {
        return (A)withToken(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1TokenRequestStatusFluentImpl that = (V1TokenRequestStatusFluentImpl) o;
        if (expirationTimestamp != null ? !expirationTimestamp.equals(that.expirationTimestamp) :that.expirationTimestamp != null) return false;
        if (token != null ? !token.equals(that.token) :that.token != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(expirationTimestamp,  token,  super.hashCode());
    }

}
