package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1TokenRequestBuilder extends V1TokenRequestFluentImpl<V1TokenRequestBuilder> implements VisitableBuilder<V1TokenRequest,V1TokenRequestBuilder> {

    V1TokenRequestFluent<?> fluent;
    Boolean validationEnabled;

    public V1TokenRequestBuilder() { 
        this(true);
    }


    public V1TokenRequestBuilder(Boolean validationEnabled) { 
        this(new V1TokenRequest(), validationEnabled);
    }


    public V1TokenRequestBuilder(V1TokenRequestFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1TokenRequestBuilder(V1TokenRequestFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1TokenRequest(), validationEnabled);
    }


    public V1TokenRequestBuilder(V1TokenRequestFluent<?> fluent,V1TokenRequest instance) { 
        this(fluent, instance, true);
    }


    public V1TokenRequestBuilder(V1TokenRequestFluent<?> fluent,V1TokenRequest instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        fluent.withSpec(instance.getSpec());

        fluent.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1TokenRequestBuilder(V1TokenRequest instance) { 
        this(instance,true);
    }


    public V1TokenRequestBuilder(V1TokenRequest instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

        this.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1TokenRequest build() {
        V1TokenRequest buildable = new V1TokenRequest();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1TokenRequestBuilder that = (V1TokenRequestBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
