package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SessionAffinityConfigBuilder extends V1SessionAffinityConfigFluentImpl<V1SessionAffinityConfigBuilder> implements VisitableBuilder<V1SessionAffinityConfig,V1SessionAffinityConfigBuilder> {

    V1SessionAffinityConfigFluent<?> fluent;
    Boolean validationEnabled;

    public V1SessionAffinityConfigBuilder() { 
        this(true);
    }


    public V1SessionAffinityConfigBuilder(Boolean validationEnabled) { 
        this(new V1SessionAffinityConfig(), validationEnabled);
    }


    public V1SessionAffinityConfigBuilder(V1SessionAffinityConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1SessionAffinityConfigBuilder(V1SessionAffinityConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1SessionAffinityConfig(), validationEnabled);
    }


    public V1SessionAffinityConfigBuilder(V1SessionAffinityConfigFluent<?> fluent,V1SessionAffinityConfig instance) { 
        this(fluent, instance, true);
    }


    public V1SessionAffinityConfigBuilder(V1SessionAffinityConfigFluent<?> fluent,V1SessionAffinityConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withClientIP(instance.getClientIP());

        this.validationEnabled = validationEnabled; 
    }


    public V1SessionAffinityConfigBuilder(V1SessionAffinityConfig instance) { 
        this(instance,true);
    }


    public V1SessionAffinityConfigBuilder(V1SessionAffinityConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withClientIP(instance.getClientIP());

        this.validationEnabled = validationEnabled; 
    }


    public V1SessionAffinityConfig build() {
        V1SessionAffinityConfig buildable = new V1SessionAffinityConfig();
        buildable.setClientIP(fluent.getClientIP());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1SessionAffinityConfigBuilder that = (V1SessionAffinityConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
