package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceAccountBuilder extends V1ServiceAccountFluentImpl<V1ServiceAccountBuilder> implements VisitableBuilder<V1ServiceAccount,V1ServiceAccountBuilder> {

    V1ServiceAccountFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceAccountBuilder() { 
        this(true);
    }


    public V1ServiceAccountBuilder(Boolean validationEnabled) { 
        this(new V1ServiceAccount(), validationEnabled);
    }


    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ServiceAccount(), validationEnabled);
    }


    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent,V1ServiceAccount instance) { 
        this(fluent, instance, true);
    }


    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent,V1ServiceAccount instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());

        fluent.withImagePullSecrets(instance.getImagePullSecrets());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        fluent.withSecrets(instance.getSecrets());

        this.validationEnabled = validationEnabled; 
    }


    public V1ServiceAccountBuilder(V1ServiceAccount instance) { 
        this(instance,true);
    }


    public V1ServiceAccountBuilder(V1ServiceAccount instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());

        this.withImagePullSecrets(instance.getImagePullSecrets());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSecrets(instance.getSecrets());

        this.validationEnabled = validationEnabled; 
    }


    public V1ServiceAccount build() {
        V1ServiceAccount buildable = new V1ServiceAccount();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setAutomountServiceAccountToken(fluent.isAutomountServiceAccountToken());
        buildable.setImagePullSecrets(fluent.getImagePullSecrets());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSecrets(fluent.getSecrets());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ServiceAccountBuilder that = (V1ServiceAccountBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
