package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1ResourceAttributesFluentImpl<A extends V1ResourceAttributesFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ResourceAttributesFluent<A> {

    private String group;
    private String name;
    private String namespace;
    private String resource;
    private String subresource;
    private String verb;
    private String version;

    public V1ResourceAttributesFluentImpl() { 
    }


    public V1ResourceAttributesFluentImpl(V1ResourceAttributes instance) { 
        this.withGroup(instance.getGroup());

        this.withName(instance.getName());

        this.withNamespace(instance.getNamespace());

        this.withResource(instance.getResource());

        this.withSubresource(instance.getSubresource());

        this.withVerb(instance.getVerb());

        this.withVersion(instance.getVersion());

    }


    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource=resource; return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuilder arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuffer arg1) {
        return (A)withResource(new String(arg1));
    }

    public String getSubresource() {
        return this.subresource;
    }

    public A withSubresource(String subresource) {
        this.subresource=subresource; return (A) this;
    }

    public Boolean hasSubresource() {
        return this.subresource != null;
    }

    public A withNewSubresource(String arg1) {
        return (A)withSubresource(new String(arg1));
    }

    public A withNewSubresource(StringBuilder arg1) {
        return (A)withSubresource(new String(arg1));
    }

    public A withNewSubresource(StringBuffer arg1) {
        return (A)withSubresource(new String(arg1));
    }

    public String getVerb() {
        return this.verb;
    }

    public A withVerb(String verb) {
        this.verb=verb; return (A) this;
    }

    public Boolean hasVerb() {
        return this.verb != null;
    }

    public A withNewVerb(String arg1) {
        return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(StringBuilder arg1) {
        return (A)withVerb(new String(arg1));
    }

    public A withNewVerb(StringBuffer arg1) {
        return (A)withVerb(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1ResourceAttributesFluentImpl that = (V1ResourceAttributesFluentImpl) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (subresource != null ? !subresource.equals(that.subresource) :that.subresource != null) return false;
        if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  name,  namespace,  resource,  subresource,  verb,  version,  super.hashCode());
    }

}
