package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1QuobyteVolumeSourceFluentImpl<A extends V1QuobyteVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1QuobyteVolumeSourceFluent<A> {

    private String group;
    private Boolean readOnly;
    private String registry;
    private String tenant;
    private String user;
    private String volume;

    public V1QuobyteVolumeSourceFluentImpl() { 
    }


    public V1QuobyteVolumeSourceFluentImpl(V1QuobyteVolumeSource instance) { 
        this.withGroup(instance.getGroup());

        this.withReadOnly(instance.getReadOnly());

        this.withRegistry(instance.getRegistry());

        this.withTenant(instance.getTenant());

        this.withUser(instance.getUser());

        this.withVolume(instance.getVolume());

    }


    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public String getRegistry() {
        return this.registry;
    }

    public A withRegistry(String registry) {
        this.registry=registry; return (A) this;
    }

    public Boolean hasRegistry() {
        return this.registry != null;
    }

    public A withNewRegistry(String arg1) {
        return (A)withRegistry(new String(arg1));
    }

    public A withNewRegistry(StringBuilder arg1) {
        return (A)withRegistry(new String(arg1));
    }

    public A withNewRegistry(StringBuffer arg1) {
        return (A)withRegistry(new String(arg1));
    }

    public String getTenant() {
        return this.tenant;
    }

    public A withTenant(String tenant) {
        this.tenant=tenant; return (A) this;
    }

    public Boolean hasTenant() {
        return this.tenant != null;
    }

    public A withNewTenant(String arg1) {
        return (A)withTenant(new String(arg1));
    }

    public A withNewTenant(StringBuilder arg1) {
        return (A)withTenant(new String(arg1));
    }

    public A withNewTenant(StringBuffer arg1) {
        return (A)withTenant(new String(arg1));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user=user; return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(String arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1) {
        return (A)withUser(new String(arg1));
    }

    public String getVolume() {
        return this.volume;
    }

    public A withVolume(String volume) {
        this.volume=volume; return (A) this;
    }

    public Boolean hasVolume() {
        return this.volume != null;
    }

    public A withNewVolume(String arg1) {
        return (A)withVolume(new String(arg1));
    }

    public A withNewVolume(StringBuilder arg1) {
        return (A)withVolume(new String(arg1));
    }

    public A withNewVolume(StringBuffer arg1) {
        return (A)withVolume(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1QuobyteVolumeSourceFluentImpl that = (V1QuobyteVolumeSourceFluentImpl) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (registry != null ? !registry.equals(that.registry) :that.registry != null) return false;
        if (tenant != null ? !tenant.equals(that.tenant) :that.tenant != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        if (volume != null ? !volume.equals(that.volume) :that.volume != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  readOnly,  registry,  tenant,  user,  volume,  super.hashCode());
    }

}
