package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodIPBuilder extends V1PodIPFluentImpl<V1PodIPBuilder> implements VisitableBuilder<V1PodIP,V1PodIPBuilder> {

    V1PodIPFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodIPBuilder() { 
        this(true);
    }


    public V1PodIPBuilder(Boolean validationEnabled) { 
        this(new V1PodIP(), validationEnabled);
    }


    public V1PodIPBuilder(V1PodIPFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1PodIPBuilder(V1PodIPFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1PodIP(), validationEnabled);
    }


    public V1PodIPBuilder(V1PodIPFluent<?> fluent,V1PodIP instance) { 
        this(fluent, instance, true);
    }


    public V1PodIPBuilder(V1PodIPFluent<?> fluent,V1PodIP instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withIp(instance.getIp());

        this.validationEnabled = validationEnabled; 
    }


    public V1PodIPBuilder(V1PodIP instance) { 
        this(instance,true);
    }


    public V1PodIPBuilder(V1PodIP instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withIp(instance.getIp());

        this.validationEnabled = validationEnabled; 
    }


    public V1PodIP build() {
        V1PodIP buildable = new V1PodIP();
        buildable.setIp(fluent.getIp());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1PodIPBuilder that = (V1PodIPBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
