package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1PhotonPersistentDiskVolumeSourceFluentImpl<A extends V1PhotonPersistentDiskVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PhotonPersistentDiskVolumeSourceFluent<A> {

    private String fsType;
    private String pdID;

    public V1PhotonPersistentDiskVolumeSourceFluentImpl() { 
    }


    public V1PhotonPersistentDiskVolumeSourceFluentImpl(V1PhotonPersistentDiskVolumeSource instance) { 
        this.withFsType(instance.getFsType());

        this.withPdID(instance.getPdID());

    }


    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType() {
        return this.fsType != null;
    }

    public A withNewFsType(String arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1) {
        return (A)withFsType(new String(arg1));
    }

    public String getPdID() {
        return this.pdID;
    }

    public A withPdID(String pdID) {
        this.pdID=pdID; return (A) this;
    }

    public Boolean hasPdID() {
        return this.pdID != null;
    }

    public A withNewPdID(String arg1) {
        return (A)withPdID(new String(arg1));
    }

    public A withNewPdID(StringBuilder arg1) {
        return (A)withPdID(new String(arg1));
    }

    public A withNewPdID(StringBuffer arg1) {
        return (A)withPdID(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1PhotonPersistentDiskVolumeSourceFluentImpl that = (V1PhotonPersistentDiskVolumeSourceFluentImpl) o;
        if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
        if (pdID != null ? !pdID.equals(that.pdID) :that.pdID != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsType,  pdID,  super.hashCode());
    }

}
