package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.custom.Quantity;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface V1PersistentVolumeClaimStatusFluent<A extends V1PersistentVolumeClaimStatusFluent<A>> extends Fluent<A> {


    public A addToAccessModes(int index,String item);
    public A setToAccessModes(int index,String item);
    public A addToAccessModes(String... items);
    public A addAllToAccessModes(Collection<String> items);
    public A removeFromAccessModes(String... items);
    public A removeAllFromAccessModes(Collection<String> items);
    public List<String> getAccessModes();
    public String getAccessMode(int index);
    public String getFirstAccessMode();
    public String getLastAccessMode();
    public String getMatchingAccessMode(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingAccessMode(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAccessModes(List<String> accessModes);
    public A withAccessModes(String... accessModes);
    public Boolean hasAccessModes();
    public A addNewAccessMode(String arg1);
    public A addNewAccessMode(StringBuilder arg1);
    public A addNewAccessMode(StringBuffer arg1);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public Boolean hasCapacity();
    public A addToConditions(int index,V1PersistentVolumeClaimCondition item);
    public A setToConditions(int index,V1PersistentVolumeClaimCondition item);
    public A addToConditions(V1PersistentVolumeClaimCondition... items);
    public A addAllToConditions(Collection<V1PersistentVolumeClaimCondition> items);
    public A removeFromConditions(V1PersistentVolumeClaimCondition... items);
    public A removeAllFromConditions(Collection<V1PersistentVolumeClaimCondition> items);
    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PersistentVolumeClaimCondition> getConditions();
    public List<V1PersistentVolumeClaimCondition> buildConditions();
    public V1PersistentVolumeClaimCondition buildCondition(int index);
    public V1PersistentVolumeClaimCondition buildFirstCondition();
    public V1PersistentVolumeClaimCondition buildLastCondition();
    public V1PersistentVolumeClaimCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimConditionBuilder> predicate);
    public A withConditions(List<V1PersistentVolumeClaimCondition> conditions);
    public A withConditions(V1PersistentVolumeClaimCondition... conditions);
    public Boolean hasConditions();
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewCondition();
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewConditionLike(V1PersistentVolumeClaimCondition item);
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1PersistentVolumeClaimCondition item);
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editLastCondition();
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimConditionBuilder> predicate);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(String arg1);
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(StringBuffer arg1);
    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PersistentVolumeClaimConditionFluent<V1PersistentVolumeClaimStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


}
