package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1LocalVolumeSourceBuilder extends V1LocalVolumeSourceFluentImpl<V1LocalVolumeSourceBuilder> implements VisitableBuilder<V1LocalVolumeSource,V1LocalVolumeSourceBuilder> {

    V1LocalVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1LocalVolumeSourceBuilder() { 
        this(true);
    }


    public V1LocalVolumeSourceBuilder(Boolean validationEnabled) { 
        this(new V1LocalVolumeSource(), validationEnabled);
    }


    public V1LocalVolumeSourceBuilder(V1LocalVolumeSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1LocalVolumeSourceBuilder(V1LocalVolumeSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1LocalVolumeSource(), validationEnabled);
    }


    public V1LocalVolumeSourceBuilder(V1LocalVolumeSourceFluent<?> fluent,V1LocalVolumeSource instance) { 
        this(fluent, instance, true);
    }


    public V1LocalVolumeSourceBuilder(V1LocalVolumeSourceFluent<?> fluent,V1LocalVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType());

        fluent.withPath(instance.getPath());

        this.validationEnabled = validationEnabled; 
    }


    public V1LocalVolumeSourceBuilder(V1LocalVolumeSource instance) { 
        this(instance,true);
    }


    public V1LocalVolumeSourceBuilder(V1LocalVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withFsType(instance.getFsType());

        this.withPath(instance.getPath());

        this.validationEnabled = validationEnabled; 
    }


    public V1LocalVolumeSource build() {
        V1LocalVolumeSource buildable = new V1LocalVolumeSource();
        buildable.setFsType(fluent.getFsType());
        buildable.setPath(fluent.getPath());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1LocalVolumeSourceBuilder that = (V1LocalVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
