package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1HTTPHeaderBuilder extends V1HTTPHeaderFluentImpl<V1HTTPHeaderBuilder> implements VisitableBuilder<V1HTTPHeader,V1HTTPHeaderBuilder> {

    V1HTTPHeaderFluent<?> fluent;
    Boolean validationEnabled;

    public V1HTTPHeaderBuilder() { 
        this(true);
    }


    public V1HTTPHeaderBuilder(Boolean validationEnabled) { 
        this(new V1HTTPHeader(), validationEnabled);
    }


    public V1HTTPHeaderBuilder(V1HTTPHeaderFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1HTTPHeaderBuilder(V1HTTPHeaderFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1HTTPHeader(), validationEnabled);
    }


    public V1HTTPHeaderBuilder(V1HTTPHeaderFluent<?> fluent,V1HTTPHeader instance) { 
        this(fluent, instance, true);
    }


    public V1HTTPHeaderBuilder(V1HTTPHeaderFluent<?> fluent,V1HTTPHeader instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName());

        fluent.withValue(instance.getValue());

        this.validationEnabled = validationEnabled; 
    }


    public V1HTTPHeaderBuilder(V1HTTPHeader instance) { 
        this(instance,true);
    }


    public V1HTTPHeaderBuilder(V1HTTPHeader instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName());

        this.withValue(instance.getValue());

        this.validationEnabled = validationEnabled; 
    }


    public V1HTTPHeader build() {
        V1HTTPHeader buildable = new V1HTTPHeader();
        buildable.setName(fluent.getName());
        buildable.setValue(fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1HTTPHeaderBuilder that = (V1HTTPHeaderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
