package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1EventSourceBuilder extends V1EventSourceFluentImpl<V1EventSourceBuilder> implements VisitableBuilder<V1EventSource,V1EventSourceBuilder> {

    V1EventSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1EventSourceBuilder() { 
        this(true);
    }


    public V1EventSourceBuilder(Boolean validationEnabled) { 
        this(new V1EventSource(), validationEnabled);
    }


    public V1EventSourceBuilder(V1EventSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1EventSourceBuilder(V1EventSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1EventSource(), validationEnabled);
    }


    public V1EventSourceBuilder(V1EventSourceFluent<?> fluent,V1EventSource instance) { 
        this(fluent, instance, true);
    }


    public V1EventSourceBuilder(V1EventSourceFluent<?> fluent,V1EventSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withComponent(instance.getComponent());

        fluent.withHost(instance.getHost());

        this.validationEnabled = validationEnabled; 
    }


    public V1EventSourceBuilder(V1EventSource instance) { 
        this(instance,true);
    }


    public V1EventSourceBuilder(V1EventSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withComponent(instance.getComponent());

        this.withHost(instance.getHost());

        this.validationEnabled = validationEnabled; 
    }


    public V1EventSource build() {
        V1EventSource buildable = new V1EventSource();
        buildable.setComponent(fluent.getComponent());
        buildable.setHost(fluent.getHost());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1EventSourceBuilder that = (V1EventSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
