package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1APIServiceStatusBuilder extends V1APIServiceStatusFluentImpl<V1APIServiceStatusBuilder> implements VisitableBuilder<V1APIServiceStatus,V1APIServiceStatusBuilder> {

    V1APIServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1APIServiceStatusBuilder() { 
        this(true);
    }


    public V1APIServiceStatusBuilder(Boolean validationEnabled) { 
        this(new V1APIServiceStatus(), validationEnabled);
    }


    public V1APIServiceStatusBuilder(V1APIServiceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1APIServiceStatusBuilder(V1APIServiceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1APIServiceStatus(), validationEnabled);
    }


    public V1APIServiceStatusBuilder(V1APIServiceStatusFluent<?> fluent,V1APIServiceStatus instance) { 
        this(fluent, instance, true);
    }


    public V1APIServiceStatusBuilder(V1APIServiceStatusFluent<?> fluent,V1APIServiceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions());

        this.validationEnabled = validationEnabled; 
    }


    public V1APIServiceStatusBuilder(V1APIServiceStatus instance) { 
        this(instance,true);
    }


    public V1APIServiceStatusBuilder(V1APIServiceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConditions(instance.getConditions());

        this.validationEnabled = validationEnabled; 
    }


    public V1APIServiceStatus build() {
        V1APIServiceStatus buildable = new V1APIServiceStatus();
        buildable.setConditions(fluent.getConditions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1APIServiceStatusBuilder that = (V1APIServiceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
