/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha1MatchResources;
import io.kubernetes.client.openapi.models.V1alpha1ParamRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.")
public class V1alpha1ValidatingAdmissionPolicyBindingSpec {
    public static final String SERIALIZED_NAME_MATCH_RESOURCES = "matchResources";
    @SerializedName(value="matchResources")
    private V1alpha1MatchResources matchResources;
    public static final String SERIALIZED_NAME_PARAM_REF = "paramRef";
    @SerializedName(value="paramRef")
    private V1alpha1ParamRef paramRef;
    public static final String SERIALIZED_NAME_POLICY_NAME = "policyName";
    @SerializedName(value="policyName")
    private String policyName;
    public static final String SERIALIZED_NAME_VALIDATION_ACTIONS = "validationActions";
    @SerializedName(value="validationActions")
    private List<String> validationActions = null;

    public V1alpha1ValidatingAdmissionPolicyBindingSpec matchResources(V1alpha1MatchResources matchResources) {
        this.matchResources = matchResources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1MatchResources getMatchResources() {
        return this.matchResources;
    }

    public void setMatchResources(V1alpha1MatchResources matchResources) {
        this.matchResources = matchResources;
    }

    public V1alpha1ValidatingAdmissionPolicyBindingSpec paramRef(V1alpha1ParamRef paramRef) {
        this.paramRef = paramRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1ParamRef getParamRef() {
        return this.paramRef;
    }

    public void setParamRef(V1alpha1ParamRef paramRef) {
        this.paramRef = paramRef;
    }

    public V1alpha1ValidatingAdmissionPolicyBindingSpec policyName(String policyName) {
        this.policyName = policyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.")
    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public V1alpha1ValidatingAdmissionPolicyBindingSpec validationActions(List<String> validationActions) {
        this.validationActions = validationActions;
        return this;
    }

    public V1alpha1ValidatingAdmissionPolicyBindingSpec addValidationActionsItem(String validationActionsItem) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.add(validationActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.  Failures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.  validationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.  The supported actions values are:  \"Deny\" specifies that a validation failure results in a denied request.  \"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.  \"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\"message\": \"Invalid value\", {\"policy\": \"policy.example.com\", {\"binding\": \"policybinding.example.com\", {\"expressionIndex\": \"1\", {\"validationActions\": [\"Audit\"]}]\"`  Clients should expect to handle additional values by ignoring any values not recognized.  \"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.  Required.")
    public List<String> getValidationActions() {
        return this.validationActions;
    }

    public void setValidationActions(List<String> validationActions) {
        this.validationActions = validationActions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ValidatingAdmissionPolicyBindingSpec v1alpha1ValidatingAdmissionPolicyBindingSpec = (V1alpha1ValidatingAdmissionPolicyBindingSpec)o;
        return Objects.equals(this.matchResources, v1alpha1ValidatingAdmissionPolicyBindingSpec.matchResources) && Objects.equals(this.paramRef, v1alpha1ValidatingAdmissionPolicyBindingSpec.paramRef) && Objects.equals(this.policyName, v1alpha1ValidatingAdmissionPolicyBindingSpec.policyName) && Objects.equals(this.validationActions, v1alpha1ValidatingAdmissionPolicyBindingSpec.validationActions);
    }

    public int hashCode() {
        return Objects.hash(this.matchResources, this.paramRef, this.policyName, this.validationActions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ValidatingAdmissionPolicyBindingSpec {\n");
        sb.append("    matchResources: ").append(this.toIndentedString(this.matchResources)).append("\n");
        sb.append("    paramRef: ").append(this.toIndentedString(this.paramRef)).append("\n");
        sb.append("    policyName: ").append(this.toIndentedString(this.policyName)).append("\n");
        sb.append("    validationActions: ").append(this.toIndentedString(this.validationActions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

