/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnExitCodesRequirement;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnExitCodesRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodFailurePolicyOnExitCodesRequirementFluentImpl<A extends V1PodFailurePolicyOnExitCodesRequirementFluent<A>>
extends BaseFluent<A>
implements V1PodFailurePolicyOnExitCodesRequirementFluent<A> {
    private String containerName;
    private String operator;
    private List<Integer> values;

    public V1PodFailurePolicyOnExitCodesRequirementFluentImpl() {
    }

    public V1PodFailurePolicyOnExitCodesRequirementFluentImpl(V1PodFailurePolicyOnExitCodesRequirement instance) {
        if (instance != null) {
            this.withContainerName(instance.getContainerName());
            this.withOperator(instance.getOperator());
            this.withValues(instance.getValues());
        }
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public A withOperator(String operator) {
        this.operator = operator;
        return (A)this;
    }

    @Override
    public Boolean hasOperator() {
        return this.operator != null;
    }

    @Override
    public A addToValues(int index, Integer item) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValues(int index, Integer item) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValues(Integer ... items) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<Integer> items) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(Integer ... items) {
        for (Integer item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Integer> getValues() {
        return this.values;
    }

    @Override
    public Integer getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public Integer getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public Integer getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public Integer getMatchingValue(Predicate<Integer> predicate) {
        for (Integer item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<Integer> predicate) {
        for (Integer item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<Integer> values) {
        if (values != null) {
            this.values = new ArrayList<Integer>();
            for (Integer item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(Integer ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove("values");
        }
        if (values != null) {
            for (Integer item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodFailurePolicyOnExitCodesRequirementFluentImpl that = (V1PodFailurePolicyOnExitCodesRequirementFluentImpl)o;
        if (!Objects.equals(this.containerName, that.containerName)) {
            return false;
        }
        if (!Objects.equals(this.operator, that.operator)) {
            return false;
        }
        return Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerName, this.operator, this.values, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerName != null) {
            sb.append("containerName:");
            sb.append(this.containerName + ",");
        }
        if (this.operator != null) {
            sb.append("operator:");
            sb.append(this.operator + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
        }
        sb.append("}");
        return sb.toString();
    }
}

