/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.")
public class V1PodFailurePolicyOnExitCodesRequirement {
    public static final String SERIALIZED_NAME_CONTAINER_NAME = "containerName";
    @SerializedName(value="containerName")
    private String containerName;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private String operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<Integer> values = new ArrayList<Integer>();

    public V1PodFailurePolicyOnExitCodesRequirement containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.")
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public V1PodFailurePolicyOnExitCodesRequirement operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:  - In: the requirement is satisfied if at least one container exit code   (might be multiple if there are multiple containers not restricted   by the 'containerName' field) is in the set of specified values. - NotIn: the requirement is satisfied if at least one container exit code   (might be multiple if there are multiple containers not restricted   by the 'containerName' field) is not in the set of specified values. Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public V1PodFailurePolicyOnExitCodesRequirement values(List<Integer> values) {
        this.values = values;
        return this;
    }

    public V1PodFailurePolicyOnExitCodesRequirement addValuesItem(Integer valuesItem) {
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.")
    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodFailurePolicyOnExitCodesRequirement v1PodFailurePolicyOnExitCodesRequirement = (V1PodFailurePolicyOnExitCodesRequirement)o;
        return Objects.equals(this.containerName, v1PodFailurePolicyOnExitCodesRequirement.containerName) && Objects.equals(this.operator, v1PodFailurePolicyOnExitCodesRequirement.operator) && Objects.equals(this.values, v1PodFailurePolicyOnExitCodesRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.operator, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodFailurePolicyOnExitCodesRequirement {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

