/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V2beta1PodsMetricStatus;
import io.kubernetes.client.openapi.models.V2beta1PodsMetricStatusFluent;
import java.util.Objects;

public class V2beta1PodsMetricStatusFluentImpl<A extends V2beta1PodsMetricStatusFluent<A>>
extends BaseFluent<A>
implements V2beta1PodsMetricStatusFluent<A> {
    private Quantity currentAverageValue;
    private String metricName;
    private V1LabelSelectorBuilder selector;

    public V2beta1PodsMetricStatusFluentImpl() {
    }

    public V2beta1PodsMetricStatusFluentImpl(V2beta1PodsMetricStatus instance) {
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
    }

    @Override
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String value) {
        return this.withCurrentAverageValue(new Quantity(value));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public A withNewMetricName(String original) {
        return this.withMetricName(new String(original));
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V2beta1PodsMetricStatusFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V2beta1PodsMetricStatusFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V2beta1PodsMetricStatusFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V2beta1PodsMetricStatusFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V2beta1PodsMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1PodsMetricStatusFluentImpl that = (V2beta1PodsMetricStatusFluentImpl)o;
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals((Object)that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        return !(this.selector != null ? !this.selector.equals(that.selector) : that.selector != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.metricName, this.selector, super.hashCode());
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V2beta1PodsMetricStatusFluent.SelectorNested<N>>
    implements V2beta1PodsMetricStatusFluent.SelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2beta1PodsMetricStatusFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

