/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehavior;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehaviorBuilder;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehaviorFluentImpl;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerSpec;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerSpecFluent;
import io.kubernetes.client.openapi.models.V2MetricSpec;
import io.kubernetes.client.openapi.models.V2MetricSpecBuilder;
import io.kubernetes.client.openapi.models.V2MetricSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V2HorizontalPodAutoscalerSpecFluentImpl<A extends V2HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements V2HorizontalPodAutoscalerSpecFluent<A> {
    private V2HorizontalPodAutoscalerBehaviorBuilder behavior;
    private Integer maxReplicas;
    private ArrayList<V2MetricSpecBuilder> metrics;
    private Integer minReplicas;
    private V2CrossVersionObjectReferenceBuilder scaleTargetRef;

    public V2HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public V2HorizontalPodAutoscalerSpecFluentImpl(V2HorizontalPodAutoscalerSpec instance) {
        this.withBehavior(instance.getBehavior());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMetrics(instance.getMetrics());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
    }

    @Override
    @Deprecated
    public V2HorizontalPodAutoscalerBehavior getBehavior() {
        return this.behavior != null ? this.behavior.build() : null;
    }

    @Override
    public V2HorizontalPodAutoscalerBehavior buildBehavior() {
        return this.behavior != null ? this.behavior.build() : null;
    }

    @Override
    public A withBehavior(V2HorizontalPodAutoscalerBehavior behavior) {
        this._visitables.get("behavior").remove(this.behavior);
        if (behavior != null) {
            this.behavior = new V2HorizontalPodAutoscalerBehaviorBuilder(behavior);
            this._visitables.get("behavior").add(this.behavior);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBehavior() {
        return this.behavior != null;
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> withNewBehavior() {
        return new BehaviorNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> withNewBehaviorLike(V2HorizontalPodAutoscalerBehavior item) {
        return new BehaviorNestedImpl(item);
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editBehavior() {
        return this.withNewBehaviorLike(this.getBehavior());
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editOrNewBehavior() {
        return this.withNewBehaviorLike(this.getBehavior() != null ? this.getBehavior() : new V2HorizontalPodAutoscalerBehaviorBuilder().build());
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editOrNewBehaviorLike(V2HorizontalPodAutoscalerBehavior item) {
        return this.withNewBehaviorLike(this.getBehavior() != null ? this.getBehavior() : item);
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public A addToMetrics(Integer index, V2MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
        this._visitables.get("metrics").add(index >= 0 ? index.intValue() : this._visitables.get("metrics").size(), builder);
        this.metrics.add(index >= 0 ? index.intValue() : this.metrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetrics(Integer index, V2MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("metrics").size()) {
            this._visitables.get("metrics").add(builder);
        } else {
            this._visitables.get("metrics").set(index, builder);
        }
        if (index < 0 || index >= this.metrics.size()) {
            this.metrics.add(builder);
        } else {
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(V2MetricSpec ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetrics(Collection<V2MetricSpec> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(V2MetricSpec ... items) {
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetrics(Collection<V2MetricSpec> items) {
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMetrics(Predicate<V2MetricSpecBuilder> predicate) {
        if (this.metrics == null) {
            return (A)this;
        }
        Iterator<V2MetricSpecBuilder> each = this.metrics.iterator();
        Object visitables = this._visitables.get("metrics");
        while (each.hasNext()) {
            V2MetricSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V2MetricSpec> getMetrics() {
        return this.metrics != null ? V2HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics) : null;
    }

    @Override
    public List<V2MetricSpec> buildMetrics() {
        return this.metrics != null ? V2HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics) : null;
    }

    @Override
    public V2MetricSpec buildMetric(Integer index) {
        return this.metrics.get(index).build();
    }

    @Override
    public V2MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    @Override
    public V2MetricSpec buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    @Override
    public V2MetricSpec buildMatchingMetric(Predicate<V2MetricSpecBuilder> predicate) {
        for (V2MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMetric(Predicate<V2MetricSpecBuilder> predicate) {
        for (V2MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMetrics(List<V2MetricSpec> metrics) {
        if (this.metrics != null) {
            this._visitables.get("metrics").removeAll(this.metrics);
        }
        if (metrics != null) {
            this.metrics = new ArrayList();
            for (V2MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    @Override
    public A withMetrics(V2MetricSpec ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
        }
        if (metrics != null) {
            for (V2MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
        return new MetricsNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(V2MetricSpec item) {
        return new MetricsNestedImpl(-1, item);
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(Integer index, V2MetricSpec item) {
        return new MetricsNestedImpl(index, item);
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(Integer index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<V2MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.test(this.metrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    @Deprecated
    public V2CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public V2CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(V2CrossVersionObjectReference scaleTargetRef) {
        this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new V2CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(V2CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new V2CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(V2CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerSpecFluentImpl that = (V2HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.behavior != null ? !this.behavior.equals(that.behavior) : that.behavior != null) {
            return false;
        }
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        return !(this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.behavior, this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef, super.hashCode());
    }

    public class ScaleTargetRefNestedImpl<N>
    extends V2CrossVersionObjectReferenceFluentImpl<V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements V2HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        V2CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(V2CrossVersionObjectReference item) {
            this.builder = new V2CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new V2CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }

    public class MetricsNestedImpl<N>
    extends V2MetricSpecFluentImpl<V2HorizontalPodAutoscalerSpecFluent.MetricsNested<N>>
    implements V2HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,
    Nested<N> {
        V2MetricSpecBuilder builder;
        Integer index;

        MetricsNestedImpl(Integer index, V2MetricSpec item) {
            this.index = index;
            this.builder = new V2MetricSpecBuilder(this, item);
        }

        MetricsNestedImpl() {
            this.index = -1;
            this.builder = new V2MetricSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(this.index, this.builder.build());
        }

        @Override
        public N endMetric() {
            return this.and();
        }
    }

    public class BehaviorNestedImpl<N>
    extends V2HorizontalPodAutoscalerBehaviorFluentImpl<V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<N>>
    implements V2HorizontalPodAutoscalerSpecFluent.BehaviorNested<N>,
    Nested<N> {
        V2HorizontalPodAutoscalerBehaviorBuilder builder;

        BehaviorNestedImpl(V2HorizontalPodAutoscalerBehavior item) {
            this.builder = new V2HorizontalPodAutoscalerBehaviorBuilder(this, item);
        }

        BehaviorNestedImpl() {
            this.builder = new V2HorizontalPodAutoscalerBehaviorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerSpecFluentImpl.this.withBehavior(this.builder.build());
        }

        @Override
        public N endBehavior() {
            return this.and();
        }
    }
}

