/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1ConditionBuilder;
import io.kubernetes.client.openapi.models.V1ConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1PodDisruptionBudgetStatus;
import io.kubernetes.client.openapi.models.V1beta1PodDisruptionBudgetStatusFluent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1beta1PodDisruptionBudgetStatusFluentImpl<A extends V1beta1PodDisruptionBudgetStatusFluent<A>>
extends BaseFluent<A>
implements V1beta1PodDisruptionBudgetStatusFluent<A> {
    private ArrayList<V1ConditionBuilder> conditions;
    private Integer currentHealthy;
    private Integer desiredHealthy;
    private Map<String, OffsetDateTime> disruptedPods;
    private Integer disruptionsAllowed;
    private Integer expectedPods;
    private Long observedGeneration;

    public V1beta1PodDisruptionBudgetStatusFluentImpl() {
    }

    public V1beta1PodDisruptionBudgetStatusFluentImpl(V1beta1PodDisruptionBudgetStatus instance) {
        this.withConditions(instance.getConditions());
        this.withCurrentHealthy(instance.getCurrentHealthy());
        this.withDesiredHealthy(instance.getDesiredHealthy());
        this.withDisruptedPods(instance.getDisruptedPods());
        this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
        this.withExpectedPods(instance.getExpectedPods());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public A addToConditions(Integer index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1Condition ... items) {
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1Condition> items) {
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Condition> getConditions() {
        return this.conditions != null ? V1beta1PodDisruptionBudgetStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1Condition> buildConditions() {
        return this.conditions != null ? V1beta1PodDisruptionBudgetStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1Condition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1Condition buildMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> addNewConditionLike(V1Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, V1Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    @Override
    public A withCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentHealthy() {
        return this.currentHealthy != null;
    }

    @Override
    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    @Override
    public A withDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredHealthy() {
        return this.desiredHealthy != null;
    }

    @Override
    public A addToDisruptedPods(String key, OffsetDateTime value) {
        if (this.disruptedPods == null && key != null && value != null) {
            this.disruptedPods = new LinkedHashMap<String, OffsetDateTime>();
        }
        if (key != null && value != null) {
            this.disruptedPods.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDisruptedPods(Map<String, OffsetDateTime> map) {
        if (this.disruptedPods == null && map != null) {
            this.disruptedPods = new LinkedHashMap<String, OffsetDateTime>();
        }
        if (map != null) {
            this.disruptedPods.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDisruptedPods(String key) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (key != null && this.disruptedPods != null) {
            this.disruptedPods.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDisruptedPods(Map<String, OffsetDateTime> map) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.disruptedPods == null) continue;
                this.disruptedPods.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, OffsetDateTime> getDisruptedPods() {
        return this.disruptedPods;
    }

    @Override
    public <K, V> A withDisruptedPods(Map<String, OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods == null ? null : new LinkedHashMap<String, OffsetDateTime>(disruptedPods);
        return (A)this;
    }

    @Override
    public Boolean hasDisruptedPods() {
        return this.disruptedPods != null;
    }

    @Override
    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    @Override
    public A withDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return (A)this;
    }

    @Override
    public Boolean hasDisruptionsAllowed() {
        return this.disruptionsAllowed != null;
    }

    @Override
    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    @Override
    public A withExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return (A)this;
    }

    @Override
    public Boolean hasExpectedPods() {
        return this.expectedPods != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1PodDisruptionBudgetStatusFluentImpl that = (V1beta1PodDisruptionBudgetStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentHealthy != null ? !this.currentHealthy.equals(that.currentHealthy) : that.currentHealthy != null) {
            return false;
        }
        if (this.desiredHealthy != null ? !this.desiredHealthy.equals(that.desiredHealthy) : that.desiredHealthy != null) {
            return false;
        }
        if (this.disruptedPods != null ? !this.disruptedPods.equals(that.disruptedPods) : that.disruptedPods != null) {
            return false;
        }
        if (this.disruptionsAllowed != null ? !this.disruptionsAllowed.equals(that.disruptionsAllowed) : that.disruptionsAllowed != null) {
            return false;
        }
        if (this.expectedPods != null ? !this.expectedPods.equals(that.expectedPods) : that.expectedPods != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHealthy, this.desiredHealthy, this.disruptedPods, this.disruptionsAllowed, this.expectedPods, this.observedGeneration, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends V1ConditionFluentImpl<V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<N>>
    implements V1beta1PodDisruptionBudgetStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1ConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, V1Condition item) {
            this.index = index;
            this.builder = new V1ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1PodDisruptionBudgetStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

