/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1TokenReviewSpec;
import io.kubernetes.client.openapi.models.V1TokenReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1TokenReviewSpecFluentImpl<A extends V1TokenReviewSpecFluent<A>>
extends BaseFluent<A>
implements V1TokenReviewSpecFluent<A> {
    private List<String> audiences;
    private String token;

    public V1TokenReviewSpecFluentImpl() {
    }

    public V1TokenReviewSpecFluentImpl(V1TokenReviewSpec instance) {
        this.withAudiences(instance.getAudiences());
        this.withToken(instance.getToken());
    }

    @Override
    public A addToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(Integer index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String original) {
        return this.addToAudiences(new String(original));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public A withToken(String token) {
        this.token = token;
        return (A)this;
    }

    @Override
    public Boolean hasToken() {
        return this.token != null;
    }

    @Override
    @Deprecated
    public A withNewToken(String original) {
        return this.withToken(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenReviewSpecFluentImpl that = (V1TokenReviewSpecFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.token, super.hashCode());
    }
}

