/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1BoundObjectReference;
import io.kubernetes.client.openapi.models.V1BoundObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1BoundObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1TokenRequestSpec;
import io.kubernetes.client.openapi.models.V1TokenRequestSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1TokenRequestSpecFluentImpl<A extends V1TokenRequestSpecFluent<A>>
extends BaseFluent<A>
implements V1TokenRequestSpecFluent<A> {
    private List<String> audiences;
    private V1BoundObjectReferenceBuilder boundObjectRef;
    private Long expirationSeconds;

    public V1TokenRequestSpecFluentImpl() {
    }

    public V1TokenRequestSpecFluentImpl(V1TokenRequestSpec instance) {
        this.withAudiences(instance.getAudiences());
        this.withBoundObjectRef(instance.getBoundObjectRef());
        this.withExpirationSeconds(instance.getExpirationSeconds());
    }

    @Override
    public A addToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(Integer index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String original) {
        return this.addToAudiences(new String(original));
    }

    @Override
    @Deprecated
    public V1BoundObjectReference getBoundObjectRef() {
        return this.boundObjectRef != null ? this.boundObjectRef.build() : null;
    }

    @Override
    public V1BoundObjectReference buildBoundObjectRef() {
        return this.boundObjectRef != null ? this.boundObjectRef.build() : null;
    }

    @Override
    public A withBoundObjectRef(V1BoundObjectReference boundObjectRef) {
        this._visitables.get("boundObjectRef").remove(this.boundObjectRef);
        if (boundObjectRef != null) {
            this.boundObjectRef = new V1BoundObjectReferenceBuilder(boundObjectRef);
            this._visitables.get("boundObjectRef").add(this.boundObjectRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBoundObjectRef() {
        return this.boundObjectRef != null;
    }

    @Override
    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> withNewBoundObjectRef() {
        return new BoundObjectRefNestedImpl();
    }

    @Override
    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> withNewBoundObjectRefLike(V1BoundObjectReference item) {
        return new BoundObjectRefNestedImpl(item);
    }

    @Override
    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> editBoundObjectRef() {
        return this.withNewBoundObjectRefLike(this.getBoundObjectRef());
    }

    @Override
    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> editOrNewBoundObjectRef() {
        return this.withNewBoundObjectRefLike(this.getBoundObjectRef() != null ? this.getBoundObjectRef() : new V1BoundObjectReferenceBuilder().build());
    }

    @Override
    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> editOrNewBoundObjectRefLike(V1BoundObjectReference item) {
        return this.withNewBoundObjectRefLike(this.getBoundObjectRef() != null ? this.getBoundObjectRef() : item);
    }

    @Override
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    @Override
    public A withExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenRequestSpecFluentImpl that = (V1TokenRequestSpecFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.boundObjectRef != null ? !this.boundObjectRef.equals(that.boundObjectRef) : that.boundObjectRef != null) {
            return false;
        }
        return !(this.expirationSeconds != null ? !this.expirationSeconds.equals(that.expirationSeconds) : that.expirationSeconds != null);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds, super.hashCode());
    }

    public class BoundObjectRefNestedImpl<N>
    extends V1BoundObjectReferenceFluentImpl<V1TokenRequestSpecFluent.BoundObjectRefNested<N>>
    implements V1TokenRequestSpecFluent.BoundObjectRefNested<N>,
    Nested<N> {
        V1BoundObjectReferenceBuilder builder;

        BoundObjectRefNestedImpl(V1BoundObjectReference item) {
            this.builder = new V1BoundObjectReferenceBuilder(this, item);
        }

        BoundObjectRefNestedImpl() {
            this.builder = new V1BoundObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1TokenRequestSpecFluentImpl.this.withBoundObjectRef(this.builder.build());
        }

        @Override
        public N endBoundObjectRef() {
            return this.and();
        }
    }
}

