/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1ServiceSpecFluent;
import io.kubernetes.client.openapi.models.V1ServiceSpecFluentImpl;
import java.util.Objects;

public class V1ServiceSpecBuilder
extends V1ServiceSpecFluentImpl<V1ServiceSpecBuilder>
implements VisitableBuilder<V1ServiceSpec, V1ServiceSpecBuilder> {
    V1ServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceSpecBuilder() {
        this(false);
    }

    public V1ServiceSpecBuilder(Boolean validationEnabled) {
        this(new V1ServiceSpec(), validationEnabled);
    }

    public V1ServiceSpecBuilder(V1ServiceSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public V1ServiceSpecBuilder(V1ServiceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1ServiceSpec(), validationEnabled);
    }

    public V1ServiceSpecBuilder(V1ServiceSpecFluent<?> fluent, V1ServiceSpec instance) {
        this(fluent, instance, false);
    }

    public V1ServiceSpecBuilder(V1ServiceSpecFluent<?> fluent, V1ServiceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
        fluent.withClusterIP(instance.getClusterIP());
        fluent.withClusterIPs(instance.getClusterIPs());
        fluent.withExternalIPs(instance.getExternalIPs());
        fluent.withExternalName(instance.getExternalName());
        fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        fluent.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        fluent.withInternalTrafficPolicy(instance.getInternalTrafficPolicy());
        fluent.withIpFamilies(instance.getIpFamilies());
        fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        fluent.withLoadBalancerClass(instance.getLoadBalancerClass());
        fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
        fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        fluent.withPorts(instance.getPorts());
        fluent.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
        fluent.withSelector(instance.getSelector());
        fluent.withSessionAffinity(instance.getSessionAffinity());
        fluent.withSessionAffinityConfig(instance.getSessionAffinityConfig());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public V1ServiceSpecBuilder(V1ServiceSpec instance) {
        this(instance, (Boolean)false);
    }

    public V1ServiceSpecBuilder(V1ServiceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
        this.withClusterIP(instance.getClusterIP());
        this.withClusterIPs(instance.getClusterIPs());
        this.withExternalIPs(instance.getExternalIPs());
        this.withExternalName(instance.getExternalName());
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy());
        this.withIpFamilies(instance.getIpFamilies());
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        this.withLoadBalancerClass(instance.getLoadBalancerClass());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        this.withPorts(instance.getPorts());
        this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withSessionAffinityConfig(instance.getSessionAffinityConfig());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1ServiceSpec build() {
        V1ServiceSpec buildable = new V1ServiceSpec();
        buildable.setAllocateLoadBalancerNodePorts(this.fluent.getAllocateLoadBalancerNodePorts());
        buildable.setClusterIP(this.fluent.getClusterIP());
        buildable.setClusterIPs(this.fluent.getClusterIPs());
        buildable.setExternalIPs(this.fluent.getExternalIPs());
        buildable.setExternalName(this.fluent.getExternalName());
        buildable.setExternalTrafficPolicy(this.fluent.getExternalTrafficPolicy());
        buildable.setHealthCheckNodePort(this.fluent.getHealthCheckNodePort());
        buildable.setInternalTrafficPolicy(this.fluent.getInternalTrafficPolicy());
        buildable.setIpFamilies(this.fluent.getIpFamilies());
        buildable.setIpFamilyPolicy(this.fluent.getIpFamilyPolicy());
        buildable.setLoadBalancerClass(this.fluent.getLoadBalancerClass());
        buildable.setLoadBalancerIP(this.fluent.getLoadBalancerIP());
        buildable.setLoadBalancerSourceRanges(this.fluent.getLoadBalancerSourceRanges());
        buildable.setPorts(this.fluent.getPorts());
        buildable.setPublishNotReadyAddresses(this.fluent.getPublishNotReadyAddresses());
        buildable.setSelector(this.fluent.getSelector());
        buildable.setSessionAffinity(this.fluent.getSessionAffinity());
        buildable.setSessionAffinityConfig(this.fluent.getSessionAffinityConfig());
        buildable.setType(this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServiceSpecBuilder that = (V1ServiceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

