/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.")
public class V1ScopedResourceSelectorRequirement {
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private OperatorEnum operator;
    public static final String SERIALIZED_NAME_SCOPE_NAME = "scopeName";
    @SerializedName(value="scopeName")
    private ScopeNameEnum scopeName;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<String> values = null;

    public V1ScopedResourceSelectorRequirement operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.  Possible enum values:  - `\"DoesNotExist\"`  - `\"Exists\"`  - `\"In\"`  - `\"NotIn\"`")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public V1ScopedResourceSelectorRequirement scopeName(ScopeNameEnum scopeName) {
        this.scopeName = scopeName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the scope that the selector applies to.  Possible enum values:  - `\"BestEffort\"` Match all pod objects that have best effort quality of service  - `\"CrossNamespacePodAffinity\"` Match all pod objects that have cross-namespace pod (anti)affinity mentioned. This is a beta feature enabled by the PodAffinityNamespaceSelector feature flag.  - `\"NotBestEffort\"` Match all pod objects that do not have best effort quality of service  - `\"NotTerminating\"` Match all pod objects where spec.activeDeadlineSeconds is nil  - `\"PriorityClass\"` Match all pod objects that have priority class mentioned  - `\"Terminating\"` Match all pod objects where spec.activeDeadlineSeconds >=0")
    public ScopeNameEnum getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(ScopeNameEnum scopeName) {
        this.scopeName = scopeName;
    }

    public V1ScopedResourceSelectorRequirement values(List<String> values) {
        this.values = values;
        return this;
    }

    public V1ScopedResourceSelectorRequirement addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ScopedResourceSelectorRequirement v1ScopedResourceSelectorRequirement = (V1ScopedResourceSelectorRequirement)o;
        return Objects.equals((Object)this.operator, (Object)v1ScopedResourceSelectorRequirement.operator) && Objects.equals((Object)this.scopeName, (Object)v1ScopedResourceSelectorRequirement.scopeName) && Objects.equals(this.values, v1ScopedResourceSelectorRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.scopeName, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ScopedResourceSelectorRequirement {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    scopeName: ").append(this.toIndentedString((Object)this.scopeName)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ScopeNameEnum {
        BESTEFFORT("BestEffort"),
        CROSSNAMESPACEPODAFFINITY("CrossNamespacePodAffinity"),
        NOTBESTEFFORT("NotBestEffort"),
        NOTTERMINATING("NotTerminating"),
        PRIORITYCLASS("PriorityClass"),
        TERMINATING("Terminating");

        private String value;

        private ScopeNameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScopeNameEnum fromValue(String value) {
            for (ScopeNameEnum b : ScopeNameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ScopeNameEnum> {
            public void write(JsonWriter jsonWriter, ScopeNameEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ScopeNameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ScopeNameEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatorEnum {
        DOESNOTEXIST("DoesNotExist"),
        EXISTS("Exists"),
        IN("In"),
        NOTIN("NotIn");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperatorEnum> {
            public void write(JsonWriter jsonWriter, OperatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatorEnum.fromValue(value);
            }
        }
    }
}

