/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ProjectedVolumeSource;
import io.kubernetes.client.openapi.models.V1ProjectedVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1VolumeProjection;
import io.kubernetes.client.openapi.models.V1VolumeProjectionBuilder;
import io.kubernetes.client.openapi.models.V1VolumeProjectionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ProjectedVolumeSourceFluentImpl<A extends V1ProjectedVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1ProjectedVolumeSourceFluent<A> {
    private Integer defaultMode;
    private ArrayList<V1VolumeProjectionBuilder> sources;

    public V1ProjectedVolumeSourceFluentImpl() {
    }

    public V1ProjectedVolumeSourceFluentImpl(V1ProjectedVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode());
        this.withSources(instance.getSources());
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A addToSources(Integer index, V1VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
        this._visitables.get("sources").add(index >= 0 ? index.intValue() : this._visitables.get("sources").size(), builder);
        this.sources.add(index >= 0 ? index.intValue() : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(Integer index, V1VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
        if (index < 0 || index >= this._visitables.get("sources").size()) {
            this._visitables.get("sources").add(builder);
        } else {
            this._visitables.get("sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(V1VolumeProjection ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<V1VolumeProjection> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(V1VolumeProjection ... items) {
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<V1VolumeProjection> items) {
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<V1VolumeProjectionBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<V1VolumeProjectionBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            V1VolumeProjectionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1VolumeProjection> getSources() {
        return this.sources != null ? V1ProjectedVolumeSourceFluentImpl.build(this.sources) : null;
    }

    @Override
    public List<V1VolumeProjection> buildSources() {
        return this.sources != null ? V1ProjectedVolumeSourceFluentImpl.build(this.sources) : null;
    }

    @Override
    public V1VolumeProjection buildSource(Integer index) {
        return this.sources.get(index).build();
    }

    @Override
    public V1VolumeProjection buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public V1VolumeProjection buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public V1VolumeProjection buildMatchingSource(Predicate<V1VolumeProjectionBuilder> predicate) {
        for (V1VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<V1VolumeProjectionBuilder> predicate) {
        for (V1VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<V1VolumeProjection> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (V1VolumeProjection item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(V1VolumeProjection ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (V1VolumeProjection item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> addNewSourceLike(V1VolumeProjection item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> setNewSourceLike(Integer index, V1VolumeProjection item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> editSource(Integer index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public V1ProjectedVolumeSourceFluent.SourcesNested<A> editMatchingSource(Predicate<V1VolumeProjectionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ProjectedVolumeSourceFluentImpl that = (V1ProjectedVolumeSourceFluentImpl)o;
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        return !(this.sources != null ? !this.sources.equals(that.sources) : that.sources != null);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources, super.hashCode());
    }

    public class SourcesNestedImpl<N>
    extends V1VolumeProjectionFluentImpl<V1ProjectedVolumeSourceFluent.SourcesNested<N>>
    implements V1ProjectedVolumeSourceFluent.SourcesNested<N>,
    Nested<N> {
        V1VolumeProjectionBuilder builder;
        Integer index;

        SourcesNestedImpl(Integer index, V1VolumeProjection item) {
            this.index = index;
            this.builder = new V1VolumeProjectionBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new V1VolumeProjectionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ProjectedVolumeSourceFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

