/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodCondition contains details for the current condition of this pod.")
public class V1PodCondition {
    public static final String SERIALIZED_NAME_LAST_PROBE_TIME = "lastProbeTime";
    @SerializedName(value="lastProbeTime")
    private OffsetDateTime lastProbeTime;
    public static final String SERIALIZED_NAME_LAST_TRANSITION_TIME = "lastTransitionTime";
    @SerializedName(value="lastTransitionTime")
    private OffsetDateTime lastTransitionTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    public V1PodCondition lastProbeTime(OffsetDateTime lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last time we probed the condition.")
    public OffsetDateTime getLastProbeTime() {
        return this.lastProbeTime;
    }

    public void setLastProbeTime(OffsetDateTime lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
    }

    public V1PodCondition lastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last time the condition transitioned from one status to another.")
    public OffsetDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V1PodCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable message indicating details about last transition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1PodCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique, one-word, CamelCase reason for the condition's last transition.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1PodCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1PodCondition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions  Possible enum values:  - `\"ContainersReady\"` indicates whether all containers in the pod are ready.  - `\"Initialized\"` means that all init containers in the pod have started successfully.  - `\"PodScheduled\"` represents status of the scheduling process for this pod.  - `\"Ready\"` means the pod is able to service requests and should be added to the load balancing pools of all matching services.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodCondition v1PodCondition = (V1PodCondition)o;
        return Objects.equals(this.lastProbeTime, v1PodCondition.lastProbeTime) && Objects.equals(this.lastTransitionTime, v1PodCondition.lastTransitionTime) && Objects.equals(this.message, v1PodCondition.message) && Objects.equals(this.reason, v1PodCondition.reason) && Objects.equals(this.status, v1PodCondition.status) && Objects.equals((Object)this.type, (Object)v1PodCondition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastProbeTime, this.lastTransitionTime, this.message, this.reason, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodCondition {\n");
        sb.append("    lastProbeTime: ").append(this.toIndentedString(this.lastProbeTime)).append("\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CONTAINERSREADY("ContainersReady"),
        INITIALIZED("Initialized"),
        PODSCHEDULED("PodScheduled"),
        READY("Ready");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

