/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PersistentVolumeStatus is the current status of a persistent volume.")
public class V1PersistentVolumeStatus {
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private PhaseEnum phase;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;

    public V1PersistentVolumeStatus message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable message indicating details about why the volume is in this state.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1PersistentVolumeStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase  Possible enum values:  - `\"Available\"` used for PersistentVolumes that are not yet bound Available volumes are held by the binder and matched to PersistentVolumeClaims  - `\"Bound\"` used for PersistentVolumes that are bound  - `\"Failed\"` used for PersistentVolumes that failed to be correctly recycled or deleted after being released from a claim  - `\"Pending\"` used for PersistentVolumes that are not available  - `\"Released\"` used for PersistentVolumes where the bound PersistentVolumeClaim was deleted released volumes must be recycled before becoming available again this phase is used by the persistent volume claim binder to signal to another process to reclaim the resource")
    public PhaseEnum getPhase() {
        return this.phase;
    }

    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public V1PersistentVolumeStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeStatus v1PersistentVolumeStatus = (V1PersistentVolumeStatus)o;
        return Objects.equals(this.message, v1PersistentVolumeStatus.message) && Objects.equals((Object)this.phase, (Object)v1PersistentVolumeStatus.phase) && Objects.equals(this.reason, v1PersistentVolumeStatus.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.phase, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeStatus {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PhaseEnum {
        AVAILABLE("Available"),
        BOUND("Bound"),
        FAILED("Failed"),
        PENDING("Pending"),
        RELEASED("Released");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PhaseEnum> {
            public void write(JsonWriter jsonWriter, PhaseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PhaseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PhaseEnum.fromValue(value);
            }
        }
    }
}

