/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PersistentVolumeClaimStatus is the current status of a persistent volume claim.")
public class V1PersistentVolumeClaimStatus {
    public static final String SERIALIZED_NAME_ACCESS_MODES = "accessModes";
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    public static final String SERIALIZED_NAME_ALLOCATED_RESOURCES = "allocatedResources";
    @SerializedName(value="allocatedResources")
    private Map<String, Quantity> allocatedResources = null;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, Quantity> capacity = null;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1PersistentVolumeClaimCondition> conditions = null;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private PhaseEnum phase;
    public static final String SERIALIZED_NAME_RESIZE_STATUS = "resizeStatus";
    @SerializedName(value="resizeStatus")
    private String resizeStatus;

    public V1PersistentVolumeClaimStatus accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimStatus addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimStatus allocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1PersistentVolumeClaimStatus putAllocatedResourcesItem(String key, Quantity allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, Quantity>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The storage resource within AllocatedResources tracks the capacity allocated to a PVC. It may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.")
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1PersistentVolumeClaimStatus capacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1PersistentVolumeClaimStatus putCapacityItem(String key, Quantity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, Quantity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the actual resources of the underlying volume.")
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    public V1PersistentVolumeClaimStatus conditions(List<V1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PersistentVolumeClaimStatus addConditionsItem(V1PersistentVolumeClaimCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.")
    public List<V1PersistentVolumeClaimCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
    }

    public V1PersistentVolumeClaimStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phase represents the current phase of PersistentVolumeClaim.  Possible enum values:  - `\"Bound\"` used for PersistentVolumeClaims that are bound  - `\"Lost\"` used for PersistentVolumeClaims that lost their underlying PersistentVolume. The claim was bound to a PersistentVolume and this volume does not exist any longer and all data on it was lost.  - `\"Pending\"` used for PersistentVolumeClaims that are not yet bound")
    public PhaseEnum getPhase() {
        return this.phase;
    }

    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public V1PersistentVolumeClaimStatus resizeStatus(String resizeStatus) {
        this.resizeStatus = resizeStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.")
    public String getResizeStatus() {
        return this.resizeStatus;
    }

    public void setResizeStatus(String resizeStatus) {
        this.resizeStatus = resizeStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimStatus v1PersistentVolumeClaimStatus = (V1PersistentVolumeClaimStatus)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimStatus.accessModes) && Objects.equals(this.allocatedResources, v1PersistentVolumeClaimStatus.allocatedResources) && Objects.equals(this.capacity, v1PersistentVolumeClaimStatus.capacity) && Objects.equals(this.conditions, v1PersistentVolumeClaimStatus.conditions) && Objects.equals((Object)this.phase, (Object)v1PersistentVolumeClaimStatus.phase) && Objects.equals(this.resizeStatus, v1PersistentVolumeClaimStatus.resizeStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessModes, this.allocatedResources, this.capacity, this.conditions, this.phase, this.resizeStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimStatus {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    allocatedResources: ").append(this.toIndentedString(this.allocatedResources)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("    resizeStatus: ").append(this.toIndentedString(this.resizeStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PhaseEnum {
        BOUND("Bound"),
        LOST("Lost"),
        PENDING("Pending");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PhaseEnum> {
            public void write(JsonWriter jsonWriter, PhaseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PhaseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PhaseEnum.fromValue(value);
            }
        }
    }
}

