/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ManagedFieldsEntry;
import io.kubernetes.client.openapi.models.V1ManagedFieldsEntryBuilder;
import io.kubernetes.client.openapi.models.V1ManagedFieldsEntryFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import io.kubernetes.client.openapi.models.V1OwnerReferenceBuilder;
import io.kubernetes.client.openapi.models.V1OwnerReferenceFluentImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ObjectMetaFluentImpl<A extends V1ObjectMetaFluent<A>>
extends BaseFluent<A>
implements V1ObjectMetaFluent<A> {
    private Map<String, String> annotations;
    private String clusterName;
    private OffsetDateTime creationTimestamp;
    private Long deletionGracePeriodSeconds;
    private OffsetDateTime deletionTimestamp;
    private List<String> finalizers;
    private String generateName;
    private Long generation;
    private Map<String, String> labels;
    private ArrayList<V1ManagedFieldsEntryBuilder> managedFields;
    private String name;
    private String namespace;
    private ArrayList<V1OwnerReferenceBuilder> ownerReferences;
    private String resourceVersion;
    private String selfLink;
    private String uid;

    public V1ObjectMetaFluentImpl() {
    }

    public V1ObjectMetaFluentImpl(V1ObjectMeta instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withClusterName(instance.getClusterName());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withLabels(instance.getLabels());
        this.withManagedFields(instance.getManagedFields());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterName() {
        return this.clusterName != null;
    }

    @Override
    @Deprecated
    public A withNewClusterName(String original) {
        return this.withClusterName(new String(original));
    }

    @Override
    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public A withCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCreationTimestamp() {
        return this.creationTimestamp != null;
    }

    @Override
    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    @Override
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds != null;
    }

    @Override
    public OffsetDateTime getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    public A withDeletionTimestamp(OffsetDateTime deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionTimestamp() {
        return this.deletionTimestamp != null;
    }

    @Override
    public A addToFinalizers(Integer index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFinalizers(Integer index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public String getFinalizer(Integer index) {
        return this.finalizers.get(index);
    }

    @Override
    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    @Override
    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    @Override
    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    @Override
    public A addNewFinalizer(String original) {
        return this.addToFinalizers(new String(original));
    }

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)this;
    }

    @Override
    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    @Override
    @Deprecated
    public A withNewGenerateName(String original) {
        return this.withGenerateName(new String(original));
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public A addToManagedFields(Integer index, V1ManagedFieldsEntry item) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
        this._visitables.get("managedFields").add(index >= 0 ? index.intValue() : this._visitables.get("managedFields").size(), builder);
        this.managedFields.add(index >= 0 ? index.intValue() : this.managedFields.size(), builder);
        return (A)this;
    }

    @Override
    public A setToManagedFields(Integer index, V1ManagedFieldsEntry item) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get("managedFields").size()) {
            this._visitables.get("managedFields").add(builder);
        } else {
            this._visitables.get("managedFields").set(index, builder);
        }
        if (index < 0 || index >= this.managedFields.size()) {
            this.managedFields.add(builder);
        } else {
            this.managedFields.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToManagedFields(V1ManagedFieldsEntry ... items) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        for (V1ManagedFieldsEntry item : items) {
            V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").add(builder);
            this.managedFields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToManagedFields(Collection<V1ManagedFieldsEntry> items) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        for (V1ManagedFieldsEntry item : items) {
            V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").add(builder);
            this.managedFields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromManagedFields(V1ManagedFieldsEntry ... items) {
        for (V1ManagedFieldsEntry item : items) {
            V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").remove(builder);
            if (this.managedFields == null) continue;
            this.managedFields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromManagedFields(Collection<V1ManagedFieldsEntry> items) {
        for (V1ManagedFieldsEntry item : items) {
            V1ManagedFieldsEntryBuilder builder = new V1ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").remove(builder);
            if (this.managedFields == null) continue;
            this.managedFields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromManagedFields(Predicate<V1ManagedFieldsEntryBuilder> predicate) {
        if (this.managedFields == null) {
            return (A)this;
        }
        Iterator<V1ManagedFieldsEntryBuilder> each = this.managedFields.iterator();
        Object visitables = this._visitables.get("managedFields");
        while (each.hasNext()) {
            V1ManagedFieldsEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ManagedFieldsEntry> getManagedFields() {
        return this.managedFields != null ? V1ObjectMetaFluentImpl.build(this.managedFields) : null;
    }

    @Override
    public List<V1ManagedFieldsEntry> buildManagedFields() {
        return this.managedFields != null ? V1ObjectMetaFluentImpl.build(this.managedFields) : null;
    }

    @Override
    public V1ManagedFieldsEntry buildManagedField(Integer index) {
        return this.managedFields.get(index).build();
    }

    @Override
    public V1ManagedFieldsEntry buildFirstManagedField() {
        return this.managedFields.get(0).build();
    }

    @Override
    public V1ManagedFieldsEntry buildLastManagedField() {
        return this.managedFields.get(this.managedFields.size() - 1).build();
    }

    @Override
    public V1ManagedFieldsEntry buildMatchingManagedField(Predicate<V1ManagedFieldsEntryBuilder> predicate) {
        for (V1ManagedFieldsEntryBuilder item : this.managedFields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingManagedField(Predicate<V1ManagedFieldsEntryBuilder> predicate) {
        for (V1ManagedFieldsEntryBuilder item : this.managedFields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withManagedFields(List<V1ManagedFieldsEntry> managedFields) {
        if (this.managedFields != null) {
            this._visitables.get("managedFields").removeAll(this.managedFields);
        }
        if (managedFields != null) {
            this.managedFields = new ArrayList();
            for (V1ManagedFieldsEntry item : managedFields) {
                this.addToManagedFields(item);
            }
        } else {
            this.managedFields = null;
        }
        return (A)this;
    }

    @Override
    public A withManagedFields(V1ManagedFieldsEntry ... managedFields) {
        if (this.managedFields != null) {
            this.managedFields.clear();
        }
        if (managedFields != null) {
            for (V1ManagedFieldsEntry item : managedFields) {
                this.addToManagedFields(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasManagedFields() {
        return this.managedFields != null && !this.managedFields.isEmpty();
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedField() {
        return new ManagedFieldsNestedImpl();
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedFieldLike(V1ManagedFieldsEntry item) {
        return new ManagedFieldsNestedImpl(-1, item);
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> setNewManagedFieldLike(Integer index, V1ManagedFieldsEntry item) {
        return new ManagedFieldsNestedImpl(index, item);
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editManagedField(Integer index) {
        if (this.managedFields.size() <= index) {
            throw new RuntimeException("Can't edit managedFields. Index exceeds size.");
        }
        return this.setNewManagedFieldLike(index, this.buildManagedField(index));
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editFirstManagedField() {
        if (this.managedFields.size() == 0) {
            throw new RuntimeException("Can't edit first managedFields. The list is empty.");
        }
        return this.setNewManagedFieldLike(0, this.buildManagedField(0));
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editLastManagedField() {
        int index = this.managedFields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last managedFields. The list is empty.");
        }
        return this.setNewManagedFieldLike(index, this.buildManagedField(index));
    }

    @Override
    public V1ObjectMetaFluent.ManagedFieldsNested<A> editMatchingManagedField(Predicate<V1ManagedFieldsEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.managedFields.size(); ++i) {
            if (!predicate.test(this.managedFields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching managedFields. No match found.");
        }
        return this.setNewManagedFieldLike(index, this.buildManagedField(index));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String original) {
        return this.withName(new String(original));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public A withNewNamespace(String original) {
        return this.withNamespace(new String(original));
    }

    @Override
    public A addToOwnerReferences(Integer index, V1OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
        this._visitables.get("ownerReferences").add(index >= 0 ? index.intValue() : this._visitables.get("ownerReferences").size(), builder);
        this.ownerReferences.add(index >= 0 ? index.intValue() : this.ownerReferences.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOwnerReferences(Integer index, V1OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("ownerReferences").size()) {
            this._visitables.get("ownerReferences").add(builder);
        } else {
            this._visitables.get("ownerReferences").set(index, builder);
        }
        if (index < 0 || index >= this.ownerReferences.size()) {
            this.ownerReferences.add(builder);
        } else {
            this.ownerReferences.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOwnerReferences(V1OwnerReference ... items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwnerReferences(Collection<V1OwnerReference> items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwnerReferences(V1OwnerReference ... items) {
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").remove(builder);
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwnerReferences(Collection<V1OwnerReference> items) {
        for (V1OwnerReference item : items) {
            V1OwnerReferenceBuilder builder = new V1OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").remove(builder);
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOwnerReferences(Predicate<V1OwnerReferenceBuilder> predicate) {
        if (this.ownerReferences == null) {
            return (A)this;
        }
        Iterator<V1OwnerReferenceBuilder> each = this.ownerReferences.iterator();
        Object visitables = this._visitables.get("ownerReferences");
        while (each.hasNext()) {
            V1OwnerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1OwnerReference> getOwnerReferences() {
        return this.ownerReferences != null ? V1ObjectMetaFluentImpl.build(this.ownerReferences) : null;
    }

    @Override
    public List<V1OwnerReference> buildOwnerReferences() {
        return this.ownerReferences != null ? V1ObjectMetaFluentImpl.build(this.ownerReferences) : null;
    }

    @Override
    public V1OwnerReference buildOwnerReference(Integer index) {
        return this.ownerReferences.get(index).build();
    }

    @Override
    public V1OwnerReference buildFirstOwnerReference() {
        return this.ownerReferences.get(0).build();
    }

    @Override
    public V1OwnerReference buildLastOwnerReference() {
        return this.ownerReferences.get(this.ownerReferences.size() - 1).build();
    }

    @Override
    public V1OwnerReference buildMatchingOwnerReference(Predicate<V1OwnerReferenceBuilder> predicate) {
        for (V1OwnerReferenceBuilder item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOwnerReference(Predicate<V1OwnerReferenceBuilder> predicate) {
        for (V1OwnerReferenceBuilder item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOwnerReferences(List<V1OwnerReference> ownerReferences) {
        if (this.ownerReferences != null) {
            this._visitables.get("ownerReferences").removeAll(this.ownerReferences);
        }
        if (ownerReferences != null) {
            this.ownerReferences = new ArrayList();
            for (V1OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        } else {
            this.ownerReferences = null;
        }
        return (A)this;
    }

    @Override
    public A withOwnerReferences(V1OwnerReference ... ownerReferences) {
        if (this.ownerReferences != null) {
            this.ownerReferences.clear();
        }
        if (ownerReferences != null) {
            for (V1OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwnerReferences() {
        return this.ownerReferences != null && !this.ownerReferences.isEmpty();
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference() {
        return new OwnerReferencesNestedImpl();
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(V1OwnerReference item) {
        return new OwnerReferencesNestedImpl(-1, item);
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(Integer index, V1OwnerReference item) {
        return new OwnerReferencesNestedImpl(index, item);
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(Integer index) {
        if (this.ownerReferences.size() <= index) {
            throw new RuntimeException("Can't edit ownerReferences. Index exceeds size.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference() {
        if (this.ownerReferences.size() == 0) {
            throw new RuntimeException("Can't edit first ownerReferences. The list is empty.");
        }
        return this.setNewOwnerReferenceLike(0, this.buildOwnerReference(0));
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference() {
        int index = this.ownerReferences.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ownerReferences. The list is empty.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public V1ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(Predicate<V1OwnerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ownerReferences.size(); ++i) {
            if (!predicate.test(this.ownerReferences.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ownerReferences. No match found.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    @Override
    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    @Override
    @Deprecated
    public A withNewResourceVersion(String original) {
        return this.withResourceVersion(new String(original));
    }

    @Override
    public String getSelfLink() {
        return this.selfLink;
    }

    @Override
    public A withSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return (A)this;
    }

    @Override
    public Boolean hasSelfLink() {
        return this.selfLink != null;
    }

    @Override
    @Deprecated
    public A withNewSelfLink(String original) {
        return this.withSelfLink(new String(original));
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    @Deprecated
    public A withNewUid(String original) {
        return this.withUid(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ObjectMetaFluentImpl that = (V1ObjectMetaFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.creationTimestamp != null ? !this.creationTimestamp.equals(that.creationTimestamp) : that.creationTimestamp != null) {
            return false;
        }
        if (this.deletionGracePeriodSeconds != null ? !this.deletionGracePeriodSeconds.equals(that.deletionGracePeriodSeconds) : that.deletionGracePeriodSeconds != null) {
            return false;
        }
        if (this.deletionTimestamp != null ? !this.deletionTimestamp.equals(that.deletionTimestamp) : that.deletionTimestamp != null) {
            return false;
        }
        if (this.finalizers != null ? !this.finalizers.equals(that.finalizers) : that.finalizers != null) {
            return false;
        }
        if (this.generateName != null ? !this.generateName.equals(that.generateName) : that.generateName != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.managedFields != null ? !this.managedFields.equals(that.managedFields) : that.managedFields != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.ownerReferences != null ? !this.ownerReferences.equals(that.ownerReferences) : that.ownerReferences != null) {
            return false;
        }
        if (this.resourceVersion != null ? !this.resourceVersion.equals(that.resourceVersion) : that.resourceVersion != null) {
            return false;
        }
        if (this.selfLink != null ? !this.selfLink.equals(that.selfLink) : that.selfLink != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.clusterName, this.creationTimestamp, this.deletionGracePeriodSeconds, this.deletionTimestamp, this.finalizers, this.generateName, this.generation, this.labels, this.managedFields, this.name, this.namespace, this.ownerReferences, this.resourceVersion, this.selfLink, this.uid, super.hashCode());
    }

    public class OwnerReferencesNestedImpl<N>
    extends V1OwnerReferenceFluentImpl<V1ObjectMetaFluent.OwnerReferencesNested<N>>
    implements V1ObjectMetaFluent.OwnerReferencesNested<N>,
    Nested<N> {
        V1OwnerReferenceBuilder builder;
        Integer index;

        OwnerReferencesNestedImpl(Integer index, V1OwnerReference item) {
            this.index = index;
            this.builder = new V1OwnerReferenceBuilder(this, item);
        }

        OwnerReferencesNestedImpl() {
            this.index = -1;
            this.builder = new V1OwnerReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ObjectMetaFluentImpl.this.setToOwnerReferences(this.index, this.builder.build());
        }

        @Override
        public N endOwnerReference() {
            return this.and();
        }
    }

    public class ManagedFieldsNestedImpl<N>
    extends V1ManagedFieldsEntryFluentImpl<V1ObjectMetaFluent.ManagedFieldsNested<N>>
    implements V1ObjectMetaFluent.ManagedFieldsNested<N>,
    Nested<N> {
        V1ManagedFieldsEntryBuilder builder;
        Integer index;

        ManagedFieldsNestedImpl(Integer index, V1ManagedFieldsEntry item) {
            this.index = index;
            this.builder = new V1ManagedFieldsEntryBuilder(this, item);
        }

        ManagedFieldsNestedImpl() {
            this.index = -1;
            this.builder = new V1ManagedFieldsEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ObjectMetaFluentImpl.this.setToManagedFields(this.index, this.builder.build());
        }

        @Override
        public N endManagedField() {
            return this.and();
        }
    }
}

