/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeFluent;
import io.kubernetes.client.openapi.models.V1NodeFluentImpl;
import java.util.Objects;

public class V1NodeBuilder
extends V1NodeFluentImpl<V1NodeBuilder>
implements VisitableBuilder<V1Node, V1NodeBuilder> {
    V1NodeFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeBuilder() {
        this(false);
    }

    public V1NodeBuilder(Boolean validationEnabled) {
        this(new V1Node(), validationEnabled);
    }

    public V1NodeBuilder(V1NodeFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public V1NodeBuilder(V1NodeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1Node(), validationEnabled);
    }

    public V1NodeBuilder(V1NodeFluent<?> fluent, V1Node instance) {
        this(fluent, instance, false);
    }

    public V1NodeBuilder(V1NodeFluent<?> fluent, V1Node instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public V1NodeBuilder(V1Node instance) {
        this(instance, (Boolean)false);
    }

    public V1NodeBuilder(V1Node instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1Node build() {
        V1Node buildable = new V1Node();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setSpec(this.fluent.getSpec());
        buildable.setStatus(this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeBuilder that = (V1NodeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

