/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicySpec;
import io.kubernetes.client.openapi.models.V1NetworkPolicySpecFluent;
import io.kubernetes.client.openapi.models.V1NetworkPolicySpecFluentImpl;
import java.util.Objects;

public class V1NetworkPolicySpecBuilder
extends V1NetworkPolicySpecFluentImpl<V1NetworkPolicySpecBuilder>
implements VisitableBuilder<V1NetworkPolicySpec, V1NetworkPolicySpecBuilder> {
    V1NetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1NetworkPolicySpecBuilder() {
        this(false);
    }

    public V1NetworkPolicySpecBuilder(Boolean validationEnabled) {
        this(new V1NetworkPolicySpec(), validationEnabled);
    }

    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1NetworkPolicySpec(), validationEnabled);
    }

    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent, V1NetworkPolicySpec instance) {
        this(fluent, instance, false);
    }

    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent, V1NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEgress(instance.getEgress());
        fluent.withIngress(instance.getIngress());
        fluent.withPodSelector(instance.getPodSelector());
        fluent.withPolicyTypes(instance.getPolicyTypes());
        this.validationEnabled = validationEnabled;
    }

    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpec instance) {
        this(instance, (Boolean)false);
    }

    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1NetworkPolicySpec build() {
        V1NetworkPolicySpec buildable = new V1NetworkPolicySpec();
        buildable.setEgress(this.fluent.getEgress());
        buildable.setIngress(this.fluent.getIngress());
        buildable.setPodSelector(this.fluent.getPodSelector());
        buildable.setPolicyTypes(this.fluent.getPolicyTypes());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NetworkPolicySpecBuilder that = (V1NetworkPolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

