/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1JobSpecFluent;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluentImpl;
import java.util.Objects;

public class V1JobSpecFluentImpl<A extends V1JobSpecFluent<A>>
extends BaseFluent<A>
implements V1JobSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private Integer backoffLimit;
    private String completionMode;
    private Integer completions;
    private Boolean manualSelector;
    private Integer parallelism;
    private V1LabelSelectorBuilder selector;
    private Boolean suspend;
    private V1PodTemplateSpecBuilder template;
    private Integer ttlSecondsAfterFinished;

    public V1JobSpecFluentImpl() {
    }

    public V1JobSpecFluentImpl(V1JobSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withBackoffLimit(instance.getBackoffLimit());
        this.withCompletionMode(instance.getCompletionMode());
        this.withCompletions(instance.getCompletions());
        this.withManualSelector(instance.getManualSelector());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withSuspend(instance.getSuspend());
        this.withTemplate(instance.getTemplate());
        this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    @Override
    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)this;
    }

    @Override
    public Boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    @Override
    public String getCompletionMode() {
        return this.completionMode;
    }

    @Override
    public A withCompletionMode(String completionMode) {
        this.completionMode = completionMode;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    @Override
    @Deprecated
    public A withNewCompletionMode(String original) {
        return this.withCompletionMode(new String(original));
    }

    @Override
    public Integer getCompletions() {
        return this.completions;
    }

    @Override
    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)this;
    }

    @Override
    public Boolean hasCompletions() {
        return this.completions != null;
    }

    @Override
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    @Override
    public A withManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return (A)this;
    }

    @Override
    public Boolean hasManualSelector() {
        return this.manualSelector != null;
    }

    @Override
    public Integer getParallelism() {
        return this.parallelism;
    }

    @Override
    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)this;
    }

    @Override
    public Boolean hasParallelism() {
        return this.parallelism != null;
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V1JobSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V1JobSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V1JobSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V1JobSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    @Deprecated
    public V1PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public V1JobSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public V1JobSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public V1JobSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public V1JobSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new V1PodTemplateSpecBuilder().build());
    }

    @Override
    public V1JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    @Override
    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)this;
    }

    @Override
    public Boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobSpecFluentImpl that = (V1JobSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.backoffLimit != null ? !this.backoffLimit.equals(that.backoffLimit) : that.backoffLimit != null) {
            return false;
        }
        if (this.completionMode != null ? !this.completionMode.equals(that.completionMode) : that.completionMode != null) {
            return false;
        }
        if (this.completions != null ? !this.completions.equals(that.completions) : that.completions != null) {
            return false;
        }
        if (this.manualSelector != null ? !this.manualSelector.equals(that.manualSelector) : that.manualSelector != null) {
            return false;
        }
        if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.suspend != null ? !this.suspend.equals(that.suspend) : that.suspend != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.ttlSecondsAfterFinished != null ? !this.ttlSecondsAfterFinished.equals(that.ttlSecondsAfterFinished) : that.ttlSecondsAfterFinished != null);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.completionMode, this.completions, this.manualSelector, this.parallelism, this.selector, this.suspend, this.template, this.ttlSecondsAfterFinished, super.hashCode());
    }

    public class TemplateNestedImpl<N>
    extends V1PodTemplateSpecFluentImpl<V1JobSpecFluent.TemplateNested<N>>
    implements V1JobSpecFluent.TemplateNested<N>,
    Nested<N> {
        V1PodTemplateSpecBuilder builder;

        TemplateNestedImpl(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new V1PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1JobSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1JobSpecFluent.SelectorNested<N>>
    implements V1JobSpecFluent.SelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1JobSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

