/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressBackendBuilder;
import io.kubernetes.client.openapi.models.V1IngressBackendFluentImpl;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressRuleBuilder;
import io.kubernetes.client.openapi.models.V1IngressRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1IngressSpec;
import io.kubernetes.client.openapi.models.V1IngressSpecFluent;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1IngressTLSBuilder;
import io.kubernetes.client.openapi.models.V1IngressTLSFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1IngressSpecFluentImpl<A extends V1IngressSpecFluent<A>>
extends BaseFluent<A>
implements V1IngressSpecFluent<A> {
    private V1IngressBackendBuilder defaultBackend;
    private String ingressClassName;
    private ArrayList<V1IngressRuleBuilder> rules;
    private ArrayList<V1IngressTLSBuilder> tls;

    public V1IngressSpecFluentImpl() {
    }

    public V1IngressSpecFluentImpl(V1IngressSpec instance) {
        this.withDefaultBackend(instance.getDefaultBackend());
        this.withIngressClassName(instance.getIngressClassName());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
    }

    @Override
    @Deprecated
    public V1IngressBackend getDefaultBackend() {
        return this.defaultBackend != null ? this.defaultBackend.build() : null;
    }

    @Override
    public V1IngressBackend buildDefaultBackend() {
        return this.defaultBackend != null ? this.defaultBackend.build() : null;
    }

    @Override
    public A withDefaultBackend(V1IngressBackend defaultBackend) {
        this._visitables.get("defaultBackend").remove(this.defaultBackend);
        if (defaultBackend != null) {
            this.defaultBackend = new V1IngressBackendBuilder(defaultBackend);
            this._visitables.get("defaultBackend").add(this.defaultBackend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultBackend() {
        return this.defaultBackend != null;
    }

    @Override
    public V1IngressSpecFluent.DefaultBackendNested<A> withNewDefaultBackend() {
        return new DefaultBackendNestedImpl();
    }

    @Override
    public V1IngressSpecFluent.DefaultBackendNested<A> withNewDefaultBackendLike(V1IngressBackend item) {
        return new DefaultBackendNestedImpl(item);
    }

    @Override
    public V1IngressSpecFluent.DefaultBackendNested<A> editDefaultBackend() {
        return this.withNewDefaultBackendLike(this.getDefaultBackend());
    }

    @Override
    public V1IngressSpecFluent.DefaultBackendNested<A> editOrNewDefaultBackend() {
        return this.withNewDefaultBackendLike(this.getDefaultBackend() != null ? this.getDefaultBackend() : new V1IngressBackendBuilder().build());
    }

    @Override
    public V1IngressSpecFluent.DefaultBackendNested<A> editOrNewDefaultBackendLike(V1IngressBackend item) {
        return this.withNewDefaultBackendLike(this.getDefaultBackend() != null ? this.getDefaultBackend() : item);
    }

    @Override
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    @Override
    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)this;
    }

    @Override
    public Boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    @Override
    @Deprecated
    public A withNewIngressClassName(String original) {
        return this.withIngressClassName(new String(original));
    }

    @Override
    public A addToRules(Integer index, V1IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index.intValue() : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index.intValue() : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(Integer index, V1IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1IngressRule ... items) {
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1IngressRule> items) {
        for (V1IngressRule item : items) {
            V1IngressRuleBuilder builder = new V1IngressRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<V1IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1IngressRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1IngressRule> getRules() {
        return this.rules != null ? V1IngressSpecFluentImpl.build(this.rules) : null;
    }

    @Override
    public List<V1IngressRule> buildRules() {
        return this.rules != null ? V1IngressSpecFluentImpl.build(this.rules) : null;
    }

    @Override
    public V1IngressRule buildRule(Integer index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1IngressRule buildMatchingRule(Predicate<V1IngressRuleBuilder> predicate) {
        for (V1IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<V1IngressRuleBuilder> predicate) {
        for (V1IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<V1IngressRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (V1IngressRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (V1IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> addNewRuleLike(V1IngressRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> setNewRuleLike(Integer index, V1IngressRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> editRule(Integer index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1IngressSpecFluent.RulesNested<A> editMatchingRule(Predicate<V1IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToTls(Integer index, V1IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
        this._visitables.get("tls").add(index >= 0 ? index.intValue() : this._visitables.get("tls").size(), builder);
        this.tls.add(index >= 0 ? index.intValue() : this.tls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTls(Integer index, V1IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
        if (index < 0 || index >= this._visitables.get("tls").size()) {
            this._visitables.get("tls").add(builder);
        } else {
            this._visitables.get("tls").set(index, builder);
        }
        if (index < 0 || index >= this.tls.size()) {
            this.tls.add(builder);
        } else {
            this.tls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTls(V1IngressTLS ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTls(Collection<V1IngressTLS> items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTls(V1IngressTLS ... items) {
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTls(Collection<V1IngressTLS> items) {
        for (V1IngressTLS item : items) {
            V1IngressTLSBuilder builder = new V1IngressTLSBuilder(item);
            this._visitables.get("tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTls(Predicate<V1IngressTLSBuilder> predicate) {
        if (this.tls == null) {
            return (A)this;
        }
        Iterator<V1IngressTLSBuilder> each = this.tls.iterator();
        Object visitables = this._visitables.get("tls");
        while (each.hasNext()) {
            V1IngressTLSBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1IngressTLS> getTls() {
        return this.tls != null ? V1IngressSpecFluentImpl.build(this.tls) : null;
    }

    @Override
    public List<V1IngressTLS> buildTls() {
        return this.tls != null ? V1IngressSpecFluentImpl.build(this.tls) : null;
    }

    @Override
    public V1IngressTLS buildTl(Integer index) {
        return this.tls.get(index).build();
    }

    @Override
    public V1IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    @Override
    public V1IngressTLS buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    @Override
    public V1IngressTLS buildMatchingTl(Predicate<V1IngressTLSBuilder> predicate) {
        for (V1IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTl(Predicate<V1IngressTLSBuilder> predicate) {
        for (V1IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTls(List<V1IngressTLS> tls) {
        if (this.tls != null) {
            this._visitables.get("tls").removeAll(this.tls);
        }
        if (tls != null) {
            this.tls = new ArrayList();
            for (V1IngressTLS item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)this;
    }

    @Override
    public A withTls(V1IngressTLS ... tls) {
        if (this.tls != null) {
            this.tls.clear();
        }
        if (tls != null) {
            for (V1IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> addNewTl() {
        return new TlsNestedImpl();
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> addNewTlLike(V1IngressTLS item) {
        return new TlsNestedImpl(-1, item);
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> setNewTlLike(Integer index, V1IngressTLS item) {
        return new TlsNestedImpl(index, item);
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> editTl(Integer index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public V1IngressSpecFluent.TlsNested<A> editMatchingTl(Predicate<V1IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressSpecFluentImpl that = (V1IngressSpecFluentImpl)o;
        if (this.defaultBackend != null ? !this.defaultBackend.equals(that.defaultBackend) : that.defaultBackend != null) {
            return false;
        }
        if (this.ingressClassName != null ? !this.ingressClassName.equals(that.ingressClassName) : that.ingressClassName != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.tls != null ? !this.tls.equals(that.tls) : that.tls != null);
    }

    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.ingressClassName, this.rules, this.tls, super.hashCode());
    }

    public class TlsNestedImpl<N>
    extends V1IngressTLSFluentImpl<V1IngressSpecFluent.TlsNested<N>>
    implements V1IngressSpecFluent.TlsNested<N>,
    Nested<N> {
        V1IngressTLSBuilder builder;
        Integer index;

        TlsNestedImpl(Integer index, V1IngressTLS item) {
            this.index = index;
            this.builder = new V1IngressTLSBuilder(this, item);
        }

        TlsNestedImpl() {
            this.index = -1;
            this.builder = new V1IngressTLSBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1IngressSpecFluentImpl.this.setToTls(this.index, this.builder.build());
        }

        @Override
        public N endTl() {
            return this.and();
        }
    }

    public class RulesNestedImpl<N>
    extends V1IngressRuleFluentImpl<V1IngressSpecFluent.RulesNested<N>>
    implements V1IngressSpecFluent.RulesNested<N>,
    Nested<N> {
        V1IngressRuleBuilder builder;
        Integer index;

        RulesNestedImpl(Integer index, V1IngressRule item) {
            this.index = index;
            this.builder = new V1IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1IngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1IngressSpecFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class DefaultBackendNestedImpl<N>
    extends V1IngressBackendFluentImpl<V1IngressSpecFluent.DefaultBackendNested<N>>
    implements V1IngressSpecFluent.DefaultBackendNested<N>,
    Nested<N> {
        V1IngressBackendBuilder builder;

        DefaultBackendNestedImpl(V1IngressBackend item) {
            this.builder = new V1IngressBackendBuilder(this, item);
        }

        DefaultBackendNestedImpl() {
            this.builder = new V1IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1IngressSpecFluentImpl.this.withDefaultBackend(this.builder.build());
        }

        @Override
        public N endDefaultBackend() {
            return this.and();
        }
    }
}

