/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortBuilder;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortFluentImpl;
import io.kubernetes.client.openapi.models.V1Endpoint;
import io.kubernetes.client.openapi.models.V1EndpointBuilder;
import io.kubernetes.client.openapi.models.V1EndpointFluentImpl;
import io.kubernetes.client.openapi.models.V1EndpointSlice;
import io.kubernetes.client.openapi.models.V1EndpointSliceFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1EndpointSliceFluentImpl<A extends V1EndpointSliceFluent<A>>
extends BaseFluent<A>
implements V1EndpointSliceFluent<A> {
    private V1EndpointSlice.AddressTypeEnum addressType;
    private String apiVersion;
    private ArrayList<V1EndpointBuilder> endpoints;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<DiscoveryV1EndpointPortBuilder> ports;

    public V1EndpointSliceFluentImpl() {
    }

    public V1EndpointSliceFluentImpl(V1EndpointSlice instance) {
        this.withAddressType(instance.getAddressType());
        this.withApiVersion(instance.getApiVersion());
        this.withEndpoints(instance.getEndpoints());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPorts(instance.getPorts());
    }

    @Override
    public V1EndpointSlice.AddressTypeEnum getAddressType() {
        return this.addressType;
    }

    @Override
    public A withAddressType(V1EndpointSlice.AddressTypeEnum addressType) {
        this.addressType = addressType;
        return (A)this;
    }

    @Override
    public Boolean hasAddressType() {
        return this.addressType != null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String original) {
        return this.withApiVersion(new String(original));
    }

    @Override
    public A addToEndpoints(Integer index, V1Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        V1EndpointBuilder builder = new V1EndpointBuilder(item);
        this._visitables.get("endpoints").add(index >= 0 ? index.intValue() : this._visitables.get("endpoints").size(), builder);
        this.endpoints.add(index >= 0 ? index.intValue() : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(Integer index, V1Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        V1EndpointBuilder builder = new V1EndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get("endpoints").size()) {
            this._visitables.get("endpoints").add(builder);
        } else {
            this._visitables.get("endpoints").set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(V1Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<V1Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(V1Endpoint ... items) {
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<V1Endpoint> items) {
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpoints(Predicate<V1EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<V1EndpointBuilder> each = this.endpoints.iterator();
        Object visitables = this._visitables.get("endpoints");
        while (each.hasNext()) {
            V1EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Endpoint> getEndpoints() {
        return this.endpoints != null ? V1EndpointSliceFluentImpl.build(this.endpoints) : null;
    }

    @Override
    public List<V1Endpoint> buildEndpoints() {
        return this.endpoints != null ? V1EndpointSliceFluentImpl.build(this.endpoints) : null;
    }

    @Override
    public V1Endpoint buildEndpoint(Integer index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public V1Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public V1Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public V1Endpoint buildMatchingEndpoint(Predicate<V1EndpointBuilder> predicate) {
        for (V1EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpoint(Predicate<V1EndpointBuilder> predicate) {
        for (V1EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpoints(List<V1Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get("endpoints").removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList();
            for (V1Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(V1Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (V1Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(V1Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(Integer index, V1Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> editEndpoint(Integer index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public V1EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<V1EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String original) {
        return this.withKind(new String(original));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1EndpointSliceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1EndpointSliceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1EndpointSliceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToPorts(Integer index, DiscoveryV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index.intValue() : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index.intValue() : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, DiscoveryV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(DiscoveryV1EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<DiscoveryV1EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(DiscoveryV1EndpointPort ... items) {
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<DiscoveryV1EndpointPort> items) {
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<DiscoveryV1EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            DiscoveryV1EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DiscoveryV1EndpointPort> getPorts() {
        return this.ports != null ? V1EndpointSliceFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<DiscoveryV1EndpointPort> buildPorts() {
        return this.ports != null ? V1EndpointSliceFluentImpl.build(this.ports) : null;
    }

    @Override
    public DiscoveryV1EndpointPort buildPort(Integer index) {
        return this.ports.get(index).build();
    }

    @Override
    public DiscoveryV1EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public DiscoveryV1EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public DiscoveryV1EndpointPort buildMatchingPort(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        for (DiscoveryV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        for (DiscoveryV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<DiscoveryV1EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (DiscoveryV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(DiscoveryV1EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (DiscoveryV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> addNewPortLike(DiscoveryV1EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> setNewPortLike(Integer index, DiscoveryV1EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> editPort(Integer index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1EndpointSliceFluent.PortsNested<A> editMatchingPort(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSliceFluentImpl that = (V1EndpointSliceFluentImpl)o;
        if (this.addressType != null ? !this.addressType.equals((Object)that.addressType) : that.addressType != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports, super.hashCode()});
    }

    public class PortsNestedImpl<N>
    extends DiscoveryV1EndpointPortFluentImpl<V1EndpointSliceFluent.PortsNested<N>>
    implements V1EndpointSliceFluent.PortsNested<N>,
    Nested<N> {
        DiscoveryV1EndpointPortBuilder builder;
        Integer index;

        PortsNestedImpl(Integer index, DiscoveryV1EndpointPort item) {
            this.index = index;
            this.builder = new DiscoveryV1EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new DiscoveryV1EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSliceFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1EndpointSliceFluent.MetadataNested<N>>
    implements V1EndpointSliceFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSliceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class EndpointsNestedImpl<N>
    extends V1EndpointFluentImpl<V1EndpointSliceFluent.EndpointsNested<N>>
    implements V1EndpointSliceFluent.EndpointsNested<N>,
    Nested<N> {
        V1EndpointBuilder builder;
        Integer index;

        EndpointsNestedImpl(Integer index, V1Endpoint item) {
            this.index = index;
            this.builder = new V1EndpointBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new V1EndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSliceFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }
}

